/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.sql;

import java.io.IOException;
import java.net.URL;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import javax.servlet.http.HttpServletRequest;
import org.kawanfw.sql.api.util.SqlUtil;
import org.kawanfw.sql.jdbc.metadata.AceQLArray;
import org.kawanfw.sql.metadata.util.GsonWsUtil;
import org.kawanfw.sql.servlet.connection.ConnectionStore;

public class ResultSetWriterUtil {
    private static final String NULL = "NULL";

    public static String treatNullValue(ResultSet resultSet, Object columnValue) throws SQLException {
        Object columnValueStr = resultSet.wasNull() ? NULL : (columnValue == null ? null : columnValue.toString());
        return columnValueStr;
    }

    public static boolean isDateTime(int columnType) {
        return columnType == 91 || columnType == 92 || columnType == 93;
    }

    public static String formatDateTimeColumn(ResultSet rs, int columnType, int columnIndex) throws SQLException {
        if (columnType == 91) {
            Date date = rs.getDate(columnIndex);
            if (date == null) {
                return NULL;
            }
            long milliseconds = date.getTime();
            return Long.toString(milliseconds);
        }
        if (columnType == 92) {
            Time time = rs.getTime(columnIndex);
            if (time == null) {
                return NULL;
            }
            long milliseconds = time.getTime();
            return Long.toString(milliseconds);
        }
        if (columnType == 93) {
            Timestamp time = rs.getTimestamp(columnIndex);
            if (time == null) {
                return NULL;
            }
            long milliseconds = time.getTime();
            return Long.toString(milliseconds);
        }
        throw new IllegalArgumentException("columnType is not a Time/Timestamp: " + columnType);
    }

    public static boolean isNumericType(int columnType) {
        return columnType == 5 || columnType == 4 || columnType == 2 || columnType == 3 || columnType == -5 || columnType == 7 || columnType == 6 || columnType == 8;
    }

    public static boolean isNStringColumn(int columnType) {
        return columnType == -15 || columnType == -9 || columnType == -16;
    }

    public static String urlFormater(ResultSet resultSet, int columnIndex, String columnValueStr) {
        String columnValueStrNew = columnValueStr;
        try {
            URL url = resultSet.getURL(columnIndex);
            if (url != null) {
                columnValueStrNew = url.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return columnValueStrNew;
    }

    public static String getDatabaseProductName(ResultSet resultSet) throws SQLException {
        Statement statement = resultSet.getStatement();
        if (statement == null) {
            return "unknown";
        }
        Connection connection = statement.getConnection();
        return new SqlUtil(connection).getDatabaseProductName();
    }

    public static boolean isCharacterType(int columnType) {
        return columnType == 1 || columnType == -15 || columnType == 12 || columnType == -9 || columnType == -1 || columnType == -16;
    }

    public static String formatArrayColumn(ResultSet resultSet, int columnIndex) throws SQLException, IOException {
        Array array = resultSet.getArray(columnIndex);
        AceQLArray aceQLArray = new AceQLArray(array);
        String jsonString = GsonWsUtil.getJSonString(aceQLArray);
        return jsonString;
    }

    public static String formatRowIdColumn(HttpServletRequest request, ResultSet resultSet, int columnIndex) throws SQLException, IOException {
        String connectionId;
        String sessionId;
        RowId rowId = resultSet.getRowId(columnIndex);
        if (rowId == null) {
            return NULL;
        }
        String username = request.getParameter("username");
        ConnectionStore connectionStore = new ConnectionStore(username, sessionId = request.getParameter("session_id"), connectionId = request.getParameter("connection_id"));
        Connection connection = connectionStore.get();
        if (connection == null) {
            throw new SQLException("SESSION_INVALIDATED");
        }
        connectionStore.put(rowId);
        return rowId.toString();
    }
}

