/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.sql;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.SqlEvent;
import org.kawanfw.sql.api.server.SqlEventWrapper;
import org.kawanfw.sql.api.server.StatementAnalyzer;
import org.kawanfw.sql.api.server.firewall.SqlFirewallManager;
import org.kawanfw.sql.api.server.listener.UpdateListener;
import org.kawanfw.sql.api.util.firewall.LearningModeExecutor;
import org.kawanfw.sql.api.util.firewall.SqlFirewallTriggerWrapper;
import org.kawanfw.sql.servlet.ServerSqlManager;
import org.kawanfw.sql.servlet.connection.RollbackUtil;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.injection.properties.ConfPropertiesStore;
import org.kawanfw.sql.servlet.injection.properties.OperationalMode;
import org.kawanfw.sql.servlet.sql.AceQLParameter;
import org.kawanfw.sql.servlet.sql.LoggerUtil;
import org.kawanfw.sql.servlet.sql.ResultSetWriter;
import org.kawanfw.sql.servlet.sql.ServerSqlUtil;
import org.kawanfw.sql.servlet.sql.ServerStatementUtil;
import org.kawanfw.sql.servlet.sql.StatementFailure;
import org.kawanfw.sql.servlet.sql.UpdateListenersCaller;
import org.kawanfw.sql.servlet.sql.json_return.JsonErrorReturn;
import org.kawanfw.sql.servlet.sql.json_return.JsonSecurityMessage;
import org.kawanfw.sql.servlet.sql.json_return.JsonUtil;
import org.kawanfw.sql.servlet.sql.parameters.ServerPreparedStatementParameters;
import org.kawanfw.sql.servlet.sql.parameters.ServerPreparedStatementParametersUtil;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.IpUtil;

public class ServerStatementRawExecute {
    private static boolean DEBUG = FrameworkDebug.isSet(ServerStatementRawExecute.class);
    public static String CR_LF = System.getProperty("line.separator");
    private Connection connection = null;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Boolean doPrettyPrinting;
    private Set<SqlFirewallManager> sqlFirewallManagers;
    private Set<UpdateListener> updateListeners;

    public ServerStatementRawExecute(HttpServletRequest request, HttpServletResponse response, Set<SqlFirewallManager> sqlFirewallManagers, Connection connection) throws SQLException {
        this.request = request;
        this.response = response;
        this.sqlFirewallManagers = sqlFirewallManagers;
        this.connection = connection;
        this.doPrettyPrinting = true;
        String database = request.getParameter("database");
        this.updateListeners = InjectedClassesStore.get().getUpdateListenerMap().get(database);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(OutputStream out) throws FileNotFoundException, IOException, SQLException {
        try {
            try {
                if (ServerStatementUtil.isPreparedStatement(this.request)) {
                    this.executePrepStatement(out);
                    return;
                } else {
                    this.executeStatement(out);
                }
                return;
            }
            catch (SecurityException e) {
                RollbackUtil.rollback(this.connection);
                JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 403, 3, e.getMessage());
                ServerSqlManager.writeLine(out, errorReturn.build());
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                RollbackUtil.rollback(this.connection);
                JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 400, 1, e.getMessage());
                ServerSqlManager.writeLine(out, errorReturn.build());
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (Exception e) {
                RollbackUtil.rollback(this.connection);
                JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 500, 4, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
                ServerSqlManager.writeLine(out, errorReturn.build());
                if (out == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    out.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void executeStatement(OutputStream out) throws SQLException, IOException {
        String username = this.request.getParameter("username");
        String database = this.request.getParameter("database");
        String sqlOrder = this.request.getParameter("sql");
        this.debug("sqlOrder   : " + sqlOrder);
        DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(database);
        try (Statement statement = null;){
            try {
                if (sqlOrder == null || sqlOrder.isEmpty()) {
                    throw new SQLException("A 'sql' statement is required.");
                }
                statement = this.connection.createStatement();
                this.debug("before new SqlSecurityChecker()");
                String ipAddress = IpUtil.getRemoteAddr(this.request);
                this.checkFirewallGeneral(username, database, sqlOrder, ipAddress);
                statement = this.connection.createStatement();
                this.debug("before executeQuery() / executeUpdate(sqlOrder)");
                this.doExecute(out, databaseConfigurator, username, database, sqlOrder, statement, ipAddress);
            }
            catch (SQLException e) {
                RollbackUtil.rollback(this.connection);
                e.printStackTrace();
                String message = StatementFailure.statementFailureBuild(sqlOrder, e.toString(), this.doPrettyPrinting);
                LoggerUtil.log(this.request, e, message);
                throw e;
            }
        }
    }

    private void executePrepStatement(OutputStream out) throws SQLException, IOException {
        String username = this.request.getParameter("username");
        String database = this.request.getParameter("database");
        String sqlOrder = this.request.getParameter("sql");
        String htlmEncoding = this.request.getParameter("html_encoding");
        Statement preparedStatement = null;
        DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(database);
        ServerPreparedStatementParameters serverPreparedStatementParameters = null;
        try {
            if (sqlOrder == null || sqlOrder.isEmpty()) {
                throw new SQLException("A 'sql' statement is required.");
            }
            preparedStatement = this.connection.prepareStatement(sqlOrder);
            this.debug("before ServerPreparedStatementParameters");
            Map<Integer, AceQLParameter> inOutStatementParameters = ServerPreparedStatementParametersUtil.buildParametersFromRequest(this.request);
            serverPreparedStatementParameters = new ServerPreparedStatementParameters(username, database, sqlOrder, (PreparedStatement)preparedStatement, inOutStatementParameters, htlmEncoding);
            try {
                serverPreparedStatementParameters.setParameters();
            }
            catch (IllegalArgumentException e) {
                JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 400, 2, e.getMessage());
                ServerSqlManager.writeLine(out, errorReturn.build());
                if (serverPreparedStatementParameters != null) {
                    serverPreparedStatementParameters.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                serverPreparedStatementParameters = null;
                return;
            }
            try {
                this.debug("before new SqlSecurityChecker()");
                String ipAddress = this.checkFirewallGeneral(username, database, sqlOrder, serverPreparedStatementParameters);
                this.debug("before execute()");
                this.doExecutePreparedStatement(out, databaseConfigurator, username, database, sqlOrder, (PreparedStatement)preparedStatement, serverPreparedStatementParameters, ipAddress);
            }
            catch (SQLException e) {
                RollbackUtil.rollback(this.connection);
                String message = StatementFailure.prepStatementFailureBuild(sqlOrder, e.toString(), serverPreparedStatementParameters.getParameterTypes(), serverPreparedStatementParameters.getParameterValues(), this.doPrettyPrinting);
                LoggerUtil.log(this.request, e, message);
                throw e;
            }
        }
        finally {
            if (serverPreparedStatementParameters != null) {
                serverPreparedStatementParameters.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            serverPreparedStatementParameters = null;
        }
    }

    private void doExecute(OutputStream out, DatabaseConfigurator databaseConfigurator, String username, String database, String sqlOrder, Statement statement, String ipAddress) throws IOException, SQLException, SecurityException {
        ServerSqlUtil.setMaxRowsToReturn(this.request, username, database, statement, databaseConfigurator);
        boolean executeResult = statement.execute(sqlOrder);
        if (!executeResult) {
            StringWriter sw = new StringWriter();
            JsonGeneratorFactory jf = JsonUtil.getJsonGeneratorFactory(true);
            JsonGenerator gen = jf.createGenerator((Writer)sw);
            gen.writeStartObject().write("status", "OK").write("row_count", statement.getUpdateCount()).writeEnd();
            gen.close();
            ArrayList<Object> parameterValues = new ArrayList<Object>();
            StatementAnalyzer analyzer = new StatementAnalyzer(sqlOrder, parameterValues);
            if (analyzer.isDelete() || analyzer.isUpdate() || analyzer.isInsert()) {
                UpdateListenersCaller updateListenersCaller = new UpdateListenersCaller(this.updateListeners, this.connection);
                updateListenersCaller.callUpdateListeners(username, database, sqlOrder, parameterValues, ipAddress, false);
            }
            ServerSqlManager.write(out, sw.toString());
        } else {
            ResultSet rs = statement.getResultSet();
            this.dumpResultSet(rs, out, sqlOrder);
        }
    }

    private void doExecutePreparedStatement(OutputStream out, DatabaseConfigurator databaseConfigurator, String username, String database, String sqlOrder, PreparedStatement preparedStatement, ServerPreparedStatementParameters serverPreparedStatementParameters, String ipAddress) throws IOException, SQLException, SecurityException {
        ServerSqlUtil.setMaxRowsToReturn(this.request, username, database, preparedStatement, databaseConfigurator);
        boolean executeResult = preparedStatement.execute();
        if (preparedStatement.getUpdateCount() != -1) {
            StringWriter sw = new StringWriter();
            JsonGeneratorFactory jf = JsonUtil.getJsonGeneratorFactory(true);
            JsonGenerator gen = jf.createGenerator((Writer)sw);
            gen.writeStartObject().write("status", "OK").write("row_count", preparedStatement.getUpdateCount()).writeEnd();
            gen.close();
            List<Object> parameterValues = serverPreparedStatementParameters.getParameterValues();
            UpdateListenersCaller updateListenersCaller = new UpdateListenersCaller(this.updateListeners, this.connection);
            updateListenersCaller.callUpdateListeners(username, database, sqlOrder, parameterValues, ipAddress, true);
            ServerSqlManager.write(out, sw.toString());
        } else {
            ResultSet rs = preparedStatement.getResultSet();
            this.dumpResultSet(rs, out, sqlOrder);
        }
    }

    private String checkFirewallGeneral(String username, String database, String sqlOrder, ServerPreparedStatementParameters serverPreparedStatementParameters) throws IOException, SQLException, SecurityException {
        String ipAddress = IpUtil.getRemoteAddr(this.request);
        OperationalMode operationalMode = ConfPropertiesStore.get().getOperationalModeMap(database);
        if (operationalMode.equals((Object)OperationalMode.off)) {
            return ipAddress;
        }
        if (operationalMode.equals((Object)OperationalMode.learning)) {
            LearningModeExecutor.learn(sqlOrder, database);
            return ipAddress;
        }
        boolean isAllowedAfterAnalysis = true;
        for (SqlFirewallManager sqlFirewallManager : this.sqlFirewallManagers) {
            SqlEvent sqlEvent;
            isAllowedAfterAnalysis = sqlFirewallManager.allowSqlRunAfterAnalysis(sqlEvent = SqlEventWrapper.sqlEventBuild(username, database, ipAddress, sqlOrder, ServerStatementUtil.isPreparedStatement(this.request), serverPreparedStatementParameters.getParameterValues(), false), this.connection);
            if (isAllowedAfterAnalysis) continue;
            SqlFirewallTriggerWrapper.runIfStatementRefused(sqlEvent, sqlFirewallManager, this.connection);
            break;
        }
        if (!isAllowedAfterAnalysis && !operationalMode.equals((Object)OperationalMode.detecting)) {
            String message = JsonSecurityMessage.prepStatementNotAllowedBuild(sqlOrder, "Prepared Statement not allowed", serverPreparedStatementParameters.getParameterTypes(), serverPreparedStatementParameters.getParameterValues(), this.doPrettyPrinting);
            throw new SecurityException(message);
        }
        return ipAddress;
    }

    private void dumpResultSet(ResultSet rs, OutputStream out, String sqlOrder) throws SQLException, IOException {
        try {
            this.debug("sqlorder: " + sqlOrder);
            JsonGeneratorFactory jf = JsonUtil.getJsonGeneratorFactory(this.doPrettyPrinting);
            JsonGenerator gen = jf.createGenerator(out);
            gen.writeStartObject().write("status", "OK");
            boolean fillResultSetMetaData = true;
            ResultSetWriter resultSetWriter = new ResultSetWriter(this.request, sqlOrder, gen, fillResultSetMetaData);
            resultSetWriter.write(rs);
            ServerSqlManager.writeLine(out);
            gen.writeEnd();
            gen.flush();
            gen.close();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    private void checkFirewallGeneral(String username, String database, String sqlOrder, String ipAddress) throws IOException, SQLException, SecurityException {
        OperationalMode operationalMode = ConfPropertiesStore.get().getOperationalModeMap(database);
        if (operationalMode.equals((Object)OperationalMode.off)) {
            return;
        }
        if (operationalMode.equals((Object)OperationalMode.learning)) {
            LearningModeExecutor.learn(sqlOrder, database);
            return;
        }
        SqlFirewallManager sqlFirewallOnDeny = null;
        boolean isAllowed = true;
        Iterator<SqlFirewallManager> iterator = this.sqlFirewallManagers.iterator();
        while (iterator.hasNext()) {
            SqlEvent sqlEvent;
            SqlFirewallManager sqlFirewallManager;
            sqlFirewallOnDeny = sqlFirewallManager = iterator.next();
            isAllowed = sqlFirewallManager.allowStatementClass(username, database, this.connection);
            if (!isAllowed || !(isAllowed = sqlFirewallManager.allowSqlRunAfterAnalysis(sqlEvent = SqlEventWrapper.sqlEventBuild(username, database, ipAddress, sqlOrder, ServerStatementUtil.isPreparedStatement(this.request), new Vector<Object>(), false), this.connection))) break;
        }
        if (!isAllowed) {
            ArrayList<Object> parameterValues = new ArrayList<Object>();
            SqlEvent sqlEvent = SqlEventWrapper.sqlEventBuild(username, database, ipAddress, sqlOrder, ServerStatementUtil.isPreparedStatement(this.request), parameterValues, false);
            SqlFirewallTriggerWrapper.runIfStatementRefused(sqlEvent, sqlFirewallOnDeny, this.connection);
            if (!operationalMode.equals((Object)OperationalMode.detecting)) {
                String message = JsonSecurityMessage.statementNotAllowedBuild(sqlOrder, "Statement not allowed", this.doPrettyPrinting);
                throw new SecurityException(message);
            }
        }
    }

    protected void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

