/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.sql.batch;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.SqlEvent;
import org.kawanfw.sql.api.server.SqlEventWrapper;
import org.kawanfw.sql.api.server.firewall.SqlFirewallManager;
import org.kawanfw.sql.api.server.listener.UpdateListener;
import org.kawanfw.sql.api.util.firewall.LearningModeExecutor;
import org.kawanfw.sql.api.util.firewall.SqlFirewallTriggerWrapper;
import org.kawanfw.sql.servlet.ServerSqlManager;
import org.kawanfw.sql.servlet.connection.RollbackUtil;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.injection.properties.ConfPropertiesStore;
import org.kawanfw.sql.servlet.injection.properties.OperationalMode;
import org.kawanfw.sql.servlet.sql.ServerStatementUtil;
import org.kawanfw.sql.servlet.sql.UpdateListenersCaller;
import org.kawanfw.sql.servlet.sql.json_return.JsonErrorReturn;
import org.kawanfw.sql.servlet.sql.json_return.JsonSecurityMessage;
import org.kawanfw.sql.servlet.sql.parameters.ServerPreparedStatementParameters;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.IpUtil;

public class ServerPreparedStatementBatch {
    private static boolean DEBUG = FrameworkDebug.isSet(ServerPreparedStatementBatch.class);
    public static String CR_LF = System.getProperty("line.separator");
    private Connection connection = null;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Boolean doPrettyPrinting;
    private Set<SqlFirewallManager> sqlFirewallManagers;
    private DatabaseConfigurator databaseConfigurator;
    private Set<UpdateListener> updateListeners;

    public ServerPreparedStatementBatch(HttpServletRequest request, HttpServletResponse response, Set<SqlFirewallManager> sqlFirewallManagers, Connection connection, DatabaseConfigurator databaseConfigurator) throws SQLException {
        this.request = request;
        this.response = response;
        this.sqlFirewallManagers = sqlFirewallManagers;
        this.connection = connection;
        this.doPrettyPrinting = true;
        this.databaseConfigurator = databaseConfigurator;
        String database = request.getParameter("database");
        this.updateListeners = InjectedClassesStore.get().getUpdateListenerMap().get(database);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeBatch(OutputStream out) throws FileNotFoundException, IOException, SQLException {
        try {
            try {
                this.executeStatement(out);
                return;
            }
            catch (SecurityException e) {
                RollbackUtil.rollback(this.connection);
                JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 403, 3, e.getMessage());
                ServerSqlManager.writeLine(out, errorReturn.build());
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                RollbackUtil.rollback(this.connection);
                JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 400, 1, e.getMessage());
                ServerSqlManager.writeLine(out, errorReturn.build());
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (Exception e) {
                RollbackUtil.rollback(this.connection);
                JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 500, 4, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
                ServerSqlManager.writeLine(out, errorReturn.build());
                if (out == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    out.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void executeStatement(OutputStream out) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 1[TRYBLOCK]], but top level block is 14[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkFirewallGeneral(String username, String database, String sqlOrder, ServerPreparedStatementParameters serverPreparedStatementParameters) throws IOException, SQLException, SecurityException {
        String ipAddress = IpUtil.getRemoteAddr(this.request);
        OperationalMode operationalMode = ConfPropertiesStore.get().getOperationalModeMap(database);
        if (operationalMode.equals((Object)OperationalMode.off)) {
            return;
        }
        if (operationalMode.equals((Object)OperationalMode.learning)) {
            LearningModeExecutor.learn(sqlOrder, database);
            return;
        }
        boolean isAllowedAfterAnalysis = true;
        for (SqlFirewallManager sqlFirewallManager : this.sqlFirewallManagers) {
            SqlEvent sqlEvent;
            isAllowedAfterAnalysis = sqlFirewallManager.allowSqlRunAfterAnalysis(sqlEvent = SqlEventWrapper.sqlEventBuild(username, database, ipAddress, sqlOrder, ServerStatementUtil.isPreparedStatement(this.request), serverPreparedStatementParameters.getParameterValues(), false), this.connection);
            if (isAllowedAfterAnalysis) continue;
            SqlFirewallTriggerWrapper.runIfStatementRefused(sqlEvent, sqlFirewallManager, this.connection);
            break;
        }
        if (!isAllowedAfterAnalysis && !operationalMode.equals((Object)OperationalMode.detecting)) {
            String message = JsonSecurityMessage.prepStatementNotAllowedBuild(sqlOrder, "Prepared Statement not allowed", serverPreparedStatementParameters.getParameterTypes(), serverPreparedStatementParameters.getParameterValues(), this.doPrettyPrinting);
            throw new SecurityException(message);
        }
    }

    private void callUpdateListenersInThread(final String sqlOrder, final List<List<Object>> parametersList, final String username, final String database, final String ipAddress) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    for (List parameterValues : parametersList) {
                        UpdateListenersCaller updateListenersCaller = new UpdateListenersCaller(ServerPreparedStatementBatch.this.updateListeners, ServerPreparedStatementBatch.this.connection);
                        updateListenersCaller.callUpdateListeners(username, database, sqlOrder, parameterValues, ipAddress, true);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    protected void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

