/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.sql.batch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.api.server.SqlEvent;
import org.kawanfw.sql.api.server.SqlEventWrapper;
import org.kawanfw.sql.api.server.firewall.SqlFirewallManager;
import org.kawanfw.sql.api.server.listener.UpdateListener;
import org.kawanfw.sql.api.util.firewall.LearningModeExecutor;
import org.kawanfw.sql.api.util.firewall.SqlFirewallTriggerWrapper;
import org.kawanfw.sql.metadata.util.GsonWsUtil;
import org.kawanfw.sql.servlet.ServerSqlManager;
import org.kawanfw.sql.servlet.connection.RollbackUtil;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.injection.properties.ConfPropertiesStore;
import org.kawanfw.sql.servlet.injection.properties.OperationalMode;
import org.kawanfw.sql.servlet.sql.LoggerUtil;
import org.kawanfw.sql.servlet.sql.ServerStatementUtil;
import org.kawanfw.sql.servlet.sql.StatementFailure;
import org.kawanfw.sql.servlet.sql.UpdateListenersCaller;
import org.kawanfw.sql.servlet.sql.dto.UpdateCountsArrayDto;
import org.kawanfw.sql.servlet.sql.json_return.JsonErrorReturn;
import org.kawanfw.sql.servlet.sql.json_return.JsonSecurityMessage;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.HtmlConverter;
import org.kawanfw.sql.util.IpUtil;

public class ServerStatementBatch {
    private static boolean DEBUG = FrameworkDebug.isSet(ServerStatementBatch.class);
    public static String CR_LF = System.getProperty("line.separator");
    private Connection connection = null;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Boolean doPrettyPrinting;
    private Set<SqlFirewallManager> sqlFirewallManagers;
    private DatabaseConfigurator databaseConfigurator;
    private Set<UpdateListener> updateListeners;

    public ServerStatementBatch(HttpServletRequest request, HttpServletResponse response, Set<SqlFirewallManager> sqlFirewallManagers, Connection connection, DatabaseConfigurator databaseConfigurator) throws SQLException {
        this.request = request;
        this.response = response;
        this.sqlFirewallManagers = sqlFirewallManagers;
        this.connection = connection;
        this.databaseConfigurator = databaseConfigurator;
        this.doPrettyPrinting = true;
        String database = request.getParameter("database");
        this.updateListeners = InjectedClassesStore.get().getUpdateListenerMap().get(database);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeBatch(OutputStream out) throws FileNotFoundException, IOException, SQLException {
        try {
            try {
                this.executeStatement(out);
                return;
            }
            catch (SecurityException e) {
                RollbackUtil.rollback(this.connection);
                JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 403, 3, e.getMessage());
                ServerSqlManager.writeLine(out, errorReturn.build());
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                RollbackUtil.rollback(this.connection);
                JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 400, 1, e.getMessage());
                ServerSqlManager.writeLine(out, errorReturn.build());
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (Exception e) {
                RollbackUtil.rollback(this.connection);
                JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 500, 4, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
                ServerSqlManager.writeLine(out, errorReturn.build());
                if (out == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    out.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void executeStatement(OutputStream out) throws SQLException, IOException {
        String username = this.request.getParameter("username");
        String database = this.request.getParameter("database");
        String blobId = this.request.getParameter("blob_id");
        this.debug("blobId: " + blobId);
        Statement statement = null;
        File blobFile = null;
        try {
            try {
                if (blobId == null || blobId.isEmpty()) {
                    throw new SQLException("blobId cannnot be null!.");
                }
                File blobsDir = this.databaseConfigurator.getBlobsDirectory(username);
                blobFile = new File(String.valueOf(blobsDir.toString()) + File.separator + blobId);
                if (!blobFile.exists()) {
                    throw new FileNotFoundException("Cannot find file of batch SQL statement for Id: " + blobId);
                }
                String ipAddress = IpUtil.getRemoteAddr(this.request);
                statement = this.connection.createStatement();
                this.debug("before statement.addBatch() loop");
                Throwable throwable = null;
                Object var10_13 = null;
                try (BufferedReader bufferedReader = new BufferedReader(new FileReader(blobFile));){
                    String line = null;
                    while ((line = bufferedReader.readLine()) != null) {
                        String sql = line.trim();
                        sql = HtmlConverter.fromHtml(sql);
                        this.debug("before new SqlSecurityChecker()");
                        this.checkFirewallGeneral(username, database, sql, ipAddress);
                        statement.addBatch(sql);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.debug("before statement.executeBatch()");
                int[] rc = statement.executeBatch();
                this.callUpdateListenersInThread(blobFile, username, database, ipAddress);
                UpdateCountsArrayDto updateCountsArrayDto = new UpdateCountsArrayDto(rc);
                String jsonString = GsonWsUtil.getJSonString(updateCountsArrayDto);
                ServerSqlManager.writeLine(out, jsonString);
            }
            catch (SQLException e) {
                RollbackUtil.rollback(this.connection);
                String message = StatementFailure.statementFailureBuild(blobId, e.toString(), this.doPrettyPrinting);
                LoggerUtil.log(this.request, e, message);
                throw e;
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (blobFile != null) {
                blobFile.delete();
            }
        }
    }

    private void callUpdateListenersInThread(final File blobFile, final String username, final String database, final String ipAddress) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ArrayList<Object> parameterValues = new ArrayList<Object>();
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (BufferedReader bufferedReader = new BufferedReader(new FileReader(blobFile));){
                        String line = null;
                        while ((line = bufferedReader.readLine()) != null) {
                            String sqlOrder = line.trim();
                            UpdateListenersCaller updateListenersCaller = new UpdateListenersCaller(ServerStatementBatch.this.updateListeners, ServerStatementBatch.this.connection);
                            updateListenersCaller.callUpdateListeners(username, database, sqlOrder, parameterValues, ipAddress, false);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    private void checkFirewallGeneral(String username, String database, String sqlOrder, String ipAddress) throws IOException, SQLException, SecurityException {
        OperationalMode operationalMode = ConfPropertiesStore.get().getOperationalModeMap(database);
        if (operationalMode.equals((Object)OperationalMode.off)) {
            return;
        }
        if (operationalMode.equals((Object)OperationalMode.learning)) {
            LearningModeExecutor.learn(sqlOrder, database);
            return;
        }
        SqlFirewallManager sqlFirewallOnDeny = null;
        boolean isAllowed = true;
        Iterator<SqlFirewallManager> iterator = this.sqlFirewallManagers.iterator();
        while (iterator.hasNext()) {
            SqlEvent sqlEvent;
            SqlFirewallManager sqlFirewallManager;
            sqlFirewallOnDeny = sqlFirewallManager = iterator.next();
            isAllowed = sqlFirewallManager.allowStatementClass(username, database, this.connection);
            if (!isAllowed || !(isAllowed = sqlFirewallManager.allowSqlRunAfterAnalysis(sqlEvent = SqlEventWrapper.sqlEventBuild(username, database, ipAddress, sqlOrder, ServerStatementUtil.isPreparedStatement(this.request), new Vector<Object>(), false), this.connection))) break;
        }
        if (!isAllowed) {
            ArrayList<Object> parameterValues = new ArrayList<Object>();
            SqlEvent sqlEvent = SqlEventWrapper.sqlEventBuild(username, database, ipAddress, sqlOrder, ServerStatementUtil.isPreparedStatement(this.request), parameterValues, false);
            SqlFirewallTriggerWrapper.runIfStatementRefused(sqlEvent, sqlFirewallOnDeny, this.connection);
            if (!operationalMode.equals((Object)OperationalMode.detecting)) {
                String message = JsonSecurityMessage.statementNotAllowedBuild(sqlOrder, "Statement not allowed", this.doPrettyPrinting);
                throw new SecurityException(message);
            }
        }
    }

    protected void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

