/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.sql.callable;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.kawanfw.sql.api.server.SqlEvent;
import org.kawanfw.sql.api.server.SqlEventWrapper;
import org.kawanfw.sql.api.server.firewall.SqlFirewallManager;
import org.kawanfw.sql.api.util.SqlUtil;
import org.kawanfw.sql.api.util.firewall.LearningModeExecutor;
import org.kawanfw.sql.api.util.firewall.SqlFirewallTriggerWrapper;
import org.kawanfw.sql.servlet.ServerSqlManager;
import org.kawanfw.sql.servlet.connection.RollbackUtil;
import org.kawanfw.sql.servlet.injection.properties.ConfPropertiesStore;
import org.kawanfw.sql.servlet.injection.properties.OperationalMode;
import org.kawanfw.sql.servlet.sql.AceQLParameter;
import org.kawanfw.sql.servlet.sql.LoggerUtil;
import org.kawanfw.sql.servlet.sql.ResultSetWriter;
import org.kawanfw.sql.servlet.sql.ServerStatementUtil;
import org.kawanfw.sql.servlet.sql.StatementFailure;
import org.kawanfw.sql.servlet.sql.callable.ServerCallableUtil;
import org.kawanfw.sql.servlet.sql.json_return.JsonErrorReturn;
import org.kawanfw.sql.servlet.sql.json_return.JsonSecurityMessage;
import org.kawanfw.sql.servlet.sql.json_return.JsonUtil;
import org.kawanfw.sql.servlet.sql.parameters.ServerPreparedStatementParameters;
import org.kawanfw.sql.servlet.sql.parameters.ServerPreparedStatementParametersUtil;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.IpUtil;

public class AdvancedServerCallableStatement {
    private static boolean DEBUG = FrameworkDebug.isSet(AdvancedServerCallableStatement.class);
    public static String CR_LF = System.getProperty("line.separator");
    private Connection connection = null;
    private HttpServletRequest request = null;
    private Set<SqlFirewallManager> sqlFirewallManagers;
    private HttpServletResponse response = null;
    private Boolean doPrettyPrinting = false;

    public AdvancedServerCallableStatement(HttpServletRequest request, HttpServletResponse response, Set<SqlFirewallManager> sqlFirewallManagers, Connection connection) throws SQLException {
        this.request = request;
        this.response = response;
        this.sqlFirewallManagers = sqlFirewallManagers;
        this.connection = connection;
        this.doPrettyPrinting = true;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeOrExecuteQuery(OutputStream out) throws FileNotFoundException, IOException, SQLException {
        OutputStream outFinal = null;
        try {
            try {
                outFinal = this.getFinalOutputStream(out);
                this.executePrepStatement(outFinal);
                return;
            }
            catch (SecurityException e) {
                RollbackUtil.rollback(this.connection);
                JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 403, 3, e.getMessage());
                ServerSqlManager.writeLine(outFinal, errorReturn.build());
                if (outFinal == null) return;
                try {
                    outFinal.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (SQLException e) {
                RollbackUtil.rollback(this.connection);
                JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 400, 1, e.getMessage());
                ServerSqlManager.writeLine(outFinal, errorReturn.build());
                if (outFinal == null) return;
                try {
                    outFinal.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (Exception e) {
                RollbackUtil.rollback(this.connection);
                JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 500, 4, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
                ServerSqlManager.writeLine(outFinal, errorReturn.build());
                if (outFinal == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    outFinal.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        finally {
            if (outFinal != null) {
                try {
                    outFinal.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private OutputStream getFinalOutputStream(OutputStream out) throws FileNotFoundException, IOException {
        String gzipResult = this.request.getParameter("gzip_result");
        boolean doGzip = Boolean.parseBoolean(gzipResult);
        if (!this.isExecuteQuery()) {
            doGzip = false;
        }
        if (doGzip) {
            GZIPOutputStream gZipOut = new GZIPOutputStream(out);
            return gZipOut;
        }
        OutputStream outFinal = out;
        return outFinal;
    }

    private void executePrepStatement(OutputStream out) throws SQLException, IOException {
        String username = this.request.getParameter("username");
        String database = this.request.getParameter("database");
        String sqlOrder = this.request.getParameter("sql");
        String htlmEncoding = this.request.getParameter("html_encoding");
        this.debug("sqlOrder        : " + sqlOrder);
        Statement callableStatement = null;
        ServerPreparedStatementParameters serverPreparedStatementParameters = null;
        try {
            if (sqlOrder == null || sqlOrder.isEmpty()) {
                throw new SQLException("A 'sql' statement is required.");
            }
            callableStatement = this.connection.prepareCall(sqlOrder);
            this.debug("before ServerPreparedStatementParameters");
            Map<Integer, AceQLParameter> inOutStatementParameters = ServerPreparedStatementParametersUtil.buildParametersFromRequest(this.request);
            serverPreparedStatementParameters = new ServerPreparedStatementParameters(username, database, sqlOrder, (PreparedStatement)callableStatement, inOutStatementParameters, htlmEncoding);
            try {
                serverPreparedStatementParameters.setParameters();
            }
            catch (IllegalArgumentException e) {
                JsonErrorReturn errorReturn = new JsonErrorReturn(this.response, 400, 2, e.getMessage());
                ServerSqlManager.writeLine(out, errorReturn.build());
                if (serverPreparedStatementParameters != null) {
                    serverPreparedStatementParameters.close();
                }
                if (callableStatement != null) {
                    callableStatement.close();
                }
                serverPreparedStatementParameters = null;
                return;
            }
            try {
                this.debug("before new SqlSecurityChecker()");
                this.checkFirewallGeneral(username, database, sqlOrder, serverPreparedStatementParameters);
                this.debug("before executeQuery() / execute()");
                if (!this.isExecuteQuery()) {
                    this.doExecute(out, (CallableStatement)callableStatement, serverPreparedStatementParameters);
                } else {
                    this.doSelect(out, sqlOrder, (CallableStatement)callableStatement, serverPreparedStatementParameters);
                }
            }
            catch (SQLException e) {
                RollbackUtil.rollback(this.connection);
                String message = StatementFailure.prepStatementFailureBuild(sqlOrder, e.toString(), serverPreparedStatementParameters.getParameterTypes(), serverPreparedStatementParameters.getParameterValues(), this.doPrettyPrinting);
                LoggerUtil.log(this.request, e, message);
                throw e;
            }
        }
        finally {
            if (serverPreparedStatementParameters != null) {
                serverPreparedStatementParameters.close();
            }
            if (callableStatement != null) {
                callableStatement.close();
            }
            serverPreparedStatementParameters = null;
        }
    }

    private void doSelect(OutputStream out, String sqlOrder, CallableStatement callableStatement, ServerPreparedStatementParameters serverPreparedStatementParameters) throws SQLException, IOException {
        try (ResultSet rs = null;){
            SqlUtil sqlUtil = new SqlUtil(this.connection);
            if (sqlUtil.isOracle()) {
                this.debug("DB is Oracle!");
                int size = serverPreparedStatementParameters.getParametersNumber();
                this.debug("Oracle Stored Procedure parameters size: " + size);
                callableStatement.registerOutParameter(size + 1, -10);
                callableStatement.executeQuery();
                rs = (ResultSet)callableStatement.getObject(size + 1);
            } else {
                rs = callableStatement.executeQuery();
            }
            JsonGeneratorFactory jf = JsonUtil.getJsonGeneratorFactory(this.doPrettyPrinting);
            JsonGenerator gen = jf.createGenerator(out);
            gen.writeStartObject().write("status", "OK");
            String fillResultSetMetaDataStr = this.request.getParameter("fill_result_set_meta_data");
            boolean fillResultSetMetaData = Boolean.parseBoolean(fillResultSetMetaDataStr);
            ResultSetWriter resultSetWriter = new ResultSetWriter(this.request, sqlOrder, gen, fillResultSetMetaData);
            resultSetWriter.write(rs);
            ServerSqlManager.writeLine(out);
            this.addToJsonOutParameters(callableStatement, serverPreparedStatementParameters, gen);
            gen.writeEnd();
            gen.flush();
            gen.close();
        }
    }

    private void doExecute(OutputStream out, CallableStatement callableStatement, ServerPreparedStatementParameters serverPreparedStatementParameters) throws IOException, SQLException, SecurityException {
        callableStatement.execute();
        StringWriter sw = new StringWriter();
        JsonGeneratorFactory jf = JsonUtil.getJsonGeneratorFactory(true);
        JsonGenerator gen = jf.createGenerator((Writer)sw);
        gen.writeStartObject().write("status", "OK");
        this.addToJsonOutParameters(callableStatement, serverPreparedStatementParameters, gen);
        gen.write("row_count", 0);
        gen.writeEnd();
        gen.flush();
        gen.close();
        ServerSqlManager.write(out, sw.toString());
    }

    private void checkFirewallGeneral(String username, String database, String sqlOrder, ServerPreparedStatementParameters serverPreparedStatementParameters) throws IOException, SQLException, SecurityException {
        OperationalMode operationalMode = ConfPropertiesStore.get().getOperationalModeMap(database);
        if (operationalMode.equals((Object)OperationalMode.off)) {
            return;
        }
        if (operationalMode.equals((Object)OperationalMode.learning)) {
            LearningModeExecutor.learn(sqlOrder, database);
            return;
        }
        boolean isAllowed = true;
        String ipAddress = IpUtil.getRemoteAddr(this.request);
        SqlFirewallManager sqlFirewallOnDeny = null;
        Iterator<SqlFirewallManager> iterator = this.sqlFirewallManagers.iterator();
        while (iterator.hasNext()) {
            SqlFirewallManager sqlFirewallManager;
            sqlFirewallOnDeny = sqlFirewallManager = iterator.next();
            SqlEvent sqlEvent = SqlEventWrapper.sqlEventBuild(username, database, ipAddress, sqlOrder, ServerStatementUtil.isPreparedStatement(this.request), serverPreparedStatementParameters.getParameterValues(), false);
            isAllowed = sqlFirewallManager.allowSqlRunAfterAnalysis(sqlEvent, this.connection);
            if (!isAllowed) break;
        }
        if (!isAllowed) {
            SqlEvent sqlEvent = SqlEventWrapper.sqlEventBuild(username, database, ipAddress, sqlOrder, ServerStatementUtil.isPreparedStatement(this.request), serverPreparedStatementParameters.getParameterValues(), false);
            SqlFirewallTriggerWrapper.runIfStatementRefused(sqlEvent, sqlFirewallOnDeny, this.connection);
            if (!operationalMode.equals((Object)OperationalMode.detecting)) {
                String message = JsonSecurityMessage.prepStatementNotAllowedBuild(sqlOrder, "Callable Statement not allowed", serverPreparedStatementParameters.getParameterTypes(), serverPreparedStatementParameters.getParameterValues(), this.doPrettyPrinting);
                throw new SecurityException(message);
            }
        }
    }

    private void addToJsonOutParameters(CallableStatement callableStatement, ServerPreparedStatementParameters serverPreparedStatementParameters, JsonGenerator gen) throws SQLException {
        String paramType;
        Map<Integer, AceQLParameter> inOutStatementParameters = serverPreparedStatementParameters.getInOutStatementParameters();
        gen.writeStartObject("parameters_out_per_index");
        for (Map.Entry<Integer, AceQLParameter> entry : inOutStatementParameters.entrySet()) {
            int outParamIndex = entry.getKey();
            AceQLParameter aceQLParameter = entry.getValue();
            paramType = aceQLParameter.getParameterType();
            if (!aceQLParameter.isOutParameter()) continue;
            String outParamValue = ServerCallableUtil.callableStatementGetStringValue(callableStatement, outParamIndex, paramType);
            if (outParamValue == null) {
                outParamValue = "NULL";
            }
            gen.write("" + outParamIndex, outParamValue);
        }
        gen.writeEnd();
        gen.writeStartObject("parameters_out_per_name");
        for (Map.Entry<Integer, AceQLParameter> entry : inOutStatementParameters.entrySet()) {
            String outParameterName;
            AceQLParameter aceQLParameter = entry.getValue();
            int paramIndex = aceQLParameter.getParameterIndex();
            paramType = aceQLParameter.getParameterType();
            if (!aceQLParameter.isOutParameter() || (outParameterName = aceQLParameter.getOutParameterName()) == null) continue;
            String outParamValue = null;
            outParamValue = ServerCallableUtil.callableStatementGetStringValue(callableStatement, paramIndex, paramType);
            gen.write(outParameterName, outParamValue);
        }
        gen.writeEnd();
    }

    private boolean isExecuteQuery() {
        return this.request.getParameter("action").equals("execute_query");
    }

    protected void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

