/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.sql.callable.aceqlproc;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.servlet.http.HttpServletRequest;
import org.kawanfw.sql.api.server.executor.ClientEvent;
import org.kawanfw.sql.api.server.executor.ClientEventWrapper;
import org.kawanfw.sql.api.server.executor.ServerQueryExecutor;
import org.kawanfw.sql.metadata.dto.ServerQueryExecutorDto;
import org.kawanfw.sql.metadata.util.GsonWsUtil;
import org.kawanfw.sql.servlet.JavaValueBuilder;
import org.kawanfw.sql.servlet.ServerSqlManager;
import org.kawanfw.sql.servlet.sql.ResultSetWriter;
import org.kawanfw.sql.servlet.sql.callable.aceqlproc.ServerQueryExecutorWrapper;
import org.kawanfw.sql.servlet.sql.json_return.JsonUtil;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.IpUtil;

public class DefaultServerQueryExecutorWrapper
implements ServerQueryExecutorWrapper {
    private static boolean DEBUG = FrameworkDebug.isSet(DefaultServerQueryExecutorWrapper.class);

    @Override
    public void executeQuery(HttpServletRequest request, OutputStream out, String action, Connection connection) throws SQLException, IOException, ClassNotFoundException {
        Constructor<?> constructor;
        String username = request.getParameter("username");
        String database = request.getParameter("database");
        String jsonString = request.getParameter("server_query_executor_dto");
        ServerQueryExecutorDto serverQueryExecutorDto = GsonWsUtil.fromJson(jsonString, ServerQueryExecutorDto.class);
        DefaultServerQueryExecutorWrapper.debug("serverQueryExecutorDto: " + serverQueryExecutorDto.toString());
        Class<?> c = null;
        String className = null;
        try {
            className = serverQueryExecutorDto.getServerQueryExecutorClassName();
            c = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("[USER CONFIGURATION]. Cannot load ServerQueryExecutor class: " + className + ". " + e.toString());
        }
        try {
            constructor = c.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new SQLException("[USER CONFIGURATION]. Cannot create constructor for ServerQueryExecutor class: " + className + ". " + e.toString());
        }
        ServerQueryExecutor serverQueryExecutor = null;
        try {
            serverQueryExecutor = (ServerQueryExecutor)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new SQLException("[USER CONFIGURATION]. Cannot create new instance for ServerQueryExecutor class: " + className + ". " + e.toString());
        }
        List<String> paramTypes = serverQueryExecutorDto.getParameterTypes();
        List<String> paramValues = serverQueryExecutorDto.getParameterValues();
        ArrayList<Object> params = new ArrayList();
        try {
            params = DefaultServerQueryExecutorWrapper.buildParametersValuesFromTypes(paramTypes, paramValues);
        }
        catch (Exception e) {
            throw new SQLException("[USER CONFIGURATION]. Cannot load parameters for ServerQueryExecutor class: " + className + ". " + e.toString());
        }
        String ipAddress = IpUtil.getRemoteAddr(request);
        ClientEvent clientEvent = ClientEventWrapper.builderClientEvent(username, database, ipAddress, params);
        ResultSet rs = serverQueryExecutor.executeQuery(clientEvent, connection);
        if (rs == null) {
            throw new SQLException("[USER CONFIGURATION]. ResultSet cannot be null! The ServerQueryExecutor class returns a null ResultSet: " + className + ". ");
        }
        DefaultServerQueryExecutorWrapper.dumpResultSetOnServletOutStream(request, rs, out);
    }

    private static List<Object> buildParametersValuesFromTypes(List<String> paramTypes, List<String> paramValues) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (paramTypes == null || paramTypes.isEmpty()) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        int i = 0;
        while (i < paramTypes.size()) {
            String value = paramValues.get(i);
            String javaType = paramTypes.get(i);
            DefaultServerQueryExecutorWrapper.debug("javaType / value: " + javaType + " / " + value);
            JavaValueBuilder javaValueBuilder = new JavaValueBuilder(javaType, value);
            values.add(javaValueBuilder.getValue());
            ++i;
        }
        return values;
    }

    private static void dumpResultSetOnServletOutStream(HttpServletRequest request, ResultSet rs, OutputStream out) throws SQLException, IOException {
        boolean doGzip = Boolean.parseBoolean(request.getParameter("gzip_result"));
        OutputStream outFinal = DefaultServerQueryExecutorWrapper.getFinalOutputStream(out, doGzip);
        boolean doPrettyPrinting = true;
        JsonGeneratorFactory jf = JsonUtil.getJsonGeneratorFactory(doPrettyPrinting);
        JsonGenerator gen = jf.createGenerator(outFinal);
        gen.writeStartObject().write("status", "OK");
        String fillResultSetMetaDataStr = request.getParameter("fill_result_set_meta_data");
        boolean fillResultSetMetaData = Boolean.parseBoolean(fillResultSetMetaDataStr);
        String sql = "select * from table";
        ResultSetWriter resultSetWriter = new ResultSetWriter(request, sql, gen, fillResultSetMetaData);
        resultSetWriter.write(rs);
        ServerSqlManager.writeLine(outFinal);
        gen.writeEnd();
        gen.flush();
        gen.close();
    }

    private static OutputStream getFinalOutputStream(OutputStream out, boolean doGzip) throws FileNotFoundException, IOException {
        if (doGzip) {
            GZIPOutputStream gZipOut = new GZIPOutputStream(out);
            return gZipOut;
        }
        OutputStream outFinal = out;
        return outFinal;
    }

    public static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

