/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.sql.json_return;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.kawanfw.sql.servlet.sql.json_return.JsonUtil;
import org.kawanfw.sql.util.Tag;

public class JsonSecurityMessage {
    protected JsonSecurityMessage() {
    }

    public static String prepStatementNotAllowedBuild(String sqlOrder, String errorMessage, Map<Integer, String> parameters, List<Object> values, boolean doPrettyPrinting) {
        try {
            JsonGeneratorFactory jf = JsonUtil.getJsonGeneratorFactory(doPrettyPrinting);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            JsonGenerator gen = jf.createGenerator((OutputStream)out);
            gen.writeStartObject();
            gen.write(Tag.PRODUCT_SECURITY, errorMessage);
            gen.write("SQL order", sqlOrder);
            gen.writeStartArray("Parameter types");
            for (Map.Entry<Integer, String> entry : parameters.entrySet()) {
                int key = entry.getKey();
                String value = entry.getValue();
                gen.writeStartObject();
                gen.write(String.valueOf(key), value);
                gen.writeEnd();
            }
            gen.writeEnd();
            gen.writeStartArray("Parameter values");
            for (Object value : values) {
                gen.write(value != null ? value.toString() : "null");
            }
            gen.writeEnd();
            gen.writeEnd();
            gen.close();
            return out.toString("UTF-8");
        }
        catch (Exception e) {
            String returnString = String.valueOf(Tag.PRODUCT_SECURITY) + " " + errorMessage + " " + sqlOrder + " " + parameters + " " + values;
            return returnString;
        }
    }

    public static String statementNotAllowedBuild(String sqlOrder, String errorMessage, boolean doPrettyPrinting) {
        try {
            JsonGeneratorFactory jf = JsonUtil.getJsonGeneratorFactory(doPrettyPrinting);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            JsonGenerator gen = jf.createGenerator((OutputStream)out);
            gen.writeStartObject();
            gen.write(Tag.PRODUCT_SECURITY, errorMessage);
            gen.write("SQL order", sqlOrder);
            gen.writeEnd();
            gen.close();
            return out.toString("UTF-8");
        }
        catch (Exception e) {
            String returnString = String.valueOf(Tag.PRODUCT_SECURITY) + " " + errorMessage + " " + sqlOrder;
            return returnString;
        }
    }
}

