/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.sql.parameters;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.kawanfw.sql.api.server.DatabaseConfigurator;
import org.kawanfw.sql.servlet.injection.classes.InjectedClassesStore;
import org.kawanfw.sql.servlet.sql.AceQLParameter;
import org.kawanfw.sql.servlet.sql.JavaSqlConversion;
import org.kawanfw.sql.servlet.sql.PostgreSqlUtil;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.HtmlConverter;
import org.kawanfw.sql.util.KeepTempFilePolicyParms;

public class ServerPreparedStatementParameters {
    private static boolean DEBUG = FrameworkDebug.isSet(ServerPreparedStatementParameters.class);
    private static String CR_LF = System.getProperty("line.separator");
    private static final String HTML_DECODED = ".html-decoded.txt";
    private Map<Integer, Object> parameterValues = new TreeMap<Integer, Object>();
    private Map<Integer, String> parameterTypes = new TreeMap<Integer, String>();
    private Map<Integer, String> parameterStringValues = new TreeMap<Integer, String>();
    private List<InputStream> inList = new Vector<InputStream>();
    private List<Reader> readerList = new Vector<Reader>();
    private List<File> blobsOrClobs = new Vector<File>();
    private String username;
    private String database;
    private String sql;
    private PreparedStatement preparedStatement = null;
    private Map<Integer, AceQLParameter> inOutStatementParameters;
    private String htlmEncoding;

    public ServerPreparedStatementParameters(String username, String database, String sql, PreparedStatement preparedStatement, Map<Integer, AceQLParameter> inOutStatementParameters, String htlmEncoding) {
        Objects.requireNonNull(username, "username cannot be null!");
        Objects.requireNonNull(database, "database cannot be null!");
        Objects.requireNonNull(sql, "sql cannot be null!");
        Objects.requireNonNull(preparedStatement, "preparedStatement cannot be null!");
        Objects.requireNonNull(inOutStatementParameters, "inOutStatementParameters cannot be null!");
        this.username = username;
        this.database = database;
        this.sql = sql;
        this.preparedStatement = preparedStatement;
        this.inOutStatementParameters = inOutStatementParameters;
        this.htlmEncoding = htlmEncoding;
    }

    public int getParametersNumber() {
        Set<Integer> set = this.inOutStatementParameters.keySet();
        return set.size();
    }

    public void setParameters() throws SQLException, IllegalArgumentException, IOException {
        if (this.inOutStatementParameters.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, AceQLParameter> entry : this.inOutStatementParameters.entrySet()) {
            int paramIndex = entry.getKey();
            AceQLParameter aceQLParameter = entry.getValue();
            String paramType = aceQLParameter.getParameterType();
            String paramValue = aceQLParameter.getParameterValue();
            String paramDirection = aceQLParameter.getParameterDirection();
            if (ServerPreparedStatementParameters.isInParameter(paramDirection) && paramValue.equals("NULL")) {
                paramValue = null;
            }
            this.debug(String.valueOf(paramIndex) + " / " + paramType + " / " + paramValue);
            this.parameterTypes.put(paramIndex, paramType);
            this.parameterStringValues.put(paramIndex, paramValue);
            if (paramValue == null) {
                this.registerNullParameter(paramIndex, paramType, paramDirection);
                continue;
            }
            if (paramType.equalsIgnoreCase("CHAR") || paramType.equalsIgnoreCase("CHARACTER") || paramType.equalsIgnoreCase("VARCHAR")) {
                this.registerCharParameter(paramIndex, paramType, paramValue, paramDirection);
                continue;
            }
            if (paramType.equalsIgnoreCase("DECIMAL") || paramType.equalsIgnoreCase("NUMERIC")) {
                this.registerDecimalOrNumericParameter(paramIndex, paramType, paramValue, paramDirection);
                continue;
            }
            if (paramType.equalsIgnoreCase("BIT")) {
                this.registerBitParameter(paramIndex, paramType, paramValue, paramDirection);
                continue;
            }
            if (paramType.equalsIgnoreCase("TINYINT") || paramType.equalsIgnoreCase("SMALLINT") || paramType.equalsIgnoreCase("INTEGER")) {
                this.registerSmallIntParameter(paramIndex, paramType, paramValue, paramDirection);
                continue;
            }
            if (paramType.equalsIgnoreCase("BIGINT")) {
                this.registerBigIntParameter(paramIndex, paramType, paramValue, paramDirection);
                continue;
            }
            if (paramType.equalsIgnoreCase("REAL")) {
                this.registerRealParameter(paramIndex, paramType, paramValue, paramDirection);
                continue;
            }
            if (paramType.equalsIgnoreCase("FLOAT") || paramType.equalsIgnoreCase("DOUBLE_PRECISION")) {
                this.registerDoublePrecision(paramIndex, paramType, paramValue, paramDirection);
                continue;
            }
            if (paramType.equalsIgnoreCase("DATE")) {
                this.registerDateParameter(paramIndex, paramType, paramValue, paramDirection);
                continue;
            }
            if (paramType.equalsIgnoreCase("TIME")) {
                this.registerTimeParameter(paramIndex, paramType, paramValue, paramDirection);
                continue;
            }
            if (paramType.equalsIgnoreCase("TIMESTAMP")) {
                this.registerTimestampParameter(paramIndex, paramType, paramValue, paramDirection);
                continue;
            }
            if (paramType.equalsIgnoreCase("LONGVARCHAR") || paramType.equalsIgnoreCase("CLOB")) {
                this.registerLongVarcharOrClobParameter(paramIndex, paramValue, paramDirection);
                continue;
            }
            if (paramType.equalsIgnoreCase("URL")) {
                this.registerUrlParameter(paramIndex, paramType, paramValue, paramDirection);
                continue;
            }
            if (paramType.equalsIgnoreCase("BINARY") || paramType.equalsIgnoreCase("VARBINARY") || paramType.equalsIgnoreCase("LONGVARBINARY") || paramType.equalsIgnoreCase("BLOB")) {
                this.registerBinaryParameter(paramIndex, paramValue, paramDirection);
                continue;
            }
            throw new IllegalArgumentException("Invalid parameter type: " + paramType + " for parameter index " + paramIndex + ".");
        }
    }

    private void registerBinaryParameter(int paramIndex, String paramValue, String paramDirection) throws IllegalArgumentException, SQLException, IOException {
        if (ServerPreparedStatementParameters.isOutParameter(paramDirection)) {
            throw new IllegalArgumentException("Invalid OUT direction. Binary stream and Blob parameters can not be OUT (parameter index " + paramIndex + ").");
        }
        this.setBinaryStream(this.preparedStatement, paramIndex, paramValue);
        this.parameterValues.put(paramIndex, paramValue);
    }

    private void registerUrlParameter(int paramIndex, String paramType, String paramValue, String paramDirection) throws SQLException, IllegalArgumentException {
        if (ServerPreparedStatementParameters.isInParameter(paramDirection)) {
            try {
                URL url = new URL(paramValue);
                this.preparedStatement.setURL(paramIndex, url);
                this.parameterValues.put(paramIndex, paramValue);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("The following URL is invalid/malformed: " + paramValue);
            }
        }
        this.registerOutParameter(paramIndex, paramType, paramDirection);
    }

    private void registerLongVarcharOrClobParameter(int paramIndex, String paramValue, String paramDirection) throws IllegalArgumentException, SQLException, IOException {
        if (ServerPreparedStatementParameters.isOutParameter(paramDirection)) {
            throw new IllegalArgumentException("Invalid OUT direction. Characters stream and Clob parameters can not be OUT. (index " + paramIndex + ").");
        }
        this.setCharacterStream(this.preparedStatement, paramIndex, paramValue);
        this.parameterValues.put(paramIndex, paramValue);
    }

    private void registerTimestampParameter(int paramIndex, String paramType, String paramValue, String paramDirection) throws NumberFormatException, SQLException {
        if (ServerPreparedStatementParameters.isInParameter(paramDirection)) {
            long timemilliseconds = Long.parseLong(paramValue);
            Timestamp theDateTime = new Timestamp(timemilliseconds);
            this.preparedStatement.setTimestamp(paramIndex, theDateTime);
            this.parameterValues.put(paramIndex, theDateTime);
        }
        this.registerOutParameter(paramIndex, paramType, paramDirection);
    }

    private void registerTimeParameter(int paramIndex, String paramType, String paramValue, String paramDirection) throws NumberFormatException, SQLException {
        if (ServerPreparedStatementParameters.isInParameter(paramDirection)) {
            long timemilliseconds = Long.parseLong(paramValue);
            Time theDateTime = new Time(timemilliseconds);
            this.preparedStatement.setTime(paramIndex, theDateTime);
            this.parameterValues.put(paramIndex, theDateTime);
        }
        this.registerOutParameter(paramIndex, paramType, paramDirection);
    }

    private void registerDateParameter(int paramIndex, String paramType, String paramValue, String paramDirection) throws NumberFormatException, SQLException {
        if (ServerPreparedStatementParameters.isInParameter(paramDirection)) {
            long timemilliseconds = Long.parseLong(paramValue);
            Date theDateTime = new Date(timemilliseconds);
            this.preparedStatement.setDate(paramIndex, theDateTime);
            this.parameterValues.put(paramIndex, theDateTime);
        }
        this.registerOutParameter(paramIndex, paramType, paramDirection);
    }

    private void registerDoublePrecision(int paramIndex, String paramType, String paramValue, String paramDirection) throws NumberFormatException, SQLException {
        if (ServerPreparedStatementParameters.isInParameter(paramDirection)) {
            Double theDouble = Double.valueOf(paramValue);
            this.preparedStatement.setDouble(paramIndex, theDouble);
            this.parameterValues.put(paramIndex, (double)theDouble);
        }
        this.registerOutParameter(paramIndex, paramType, paramDirection);
    }

    private void registerRealParameter(int paramIndex, String paramType, String paramValue, String paramDirection) throws NumberFormatException, SQLException {
        if (ServerPreparedStatementParameters.isInParameter(paramDirection)) {
            Float theFloat = Float.valueOf(Float.parseFloat(paramValue));
            this.preparedStatement.setFloat(paramIndex, theFloat.floatValue());
            this.parameterValues.put(paramIndex, Float.valueOf(theFloat.floatValue()));
        }
        this.registerOutParameter(paramIndex, paramType, paramDirection);
    }

    private void registerBigIntParameter(int paramIndex, String paramType, String paramValue, String paramDirection) throws NumberFormatException, SQLException {
        if (ServerPreparedStatementParameters.isInParameter(paramDirection)) {
            Long theLong = Long.parseLong(paramValue);
            this.preparedStatement.setLong(paramIndex, theLong);
            this.parameterValues.put(paramIndex, (long)theLong);
        }
        this.registerOutParameter(paramIndex, paramType, paramDirection);
    }

    private void registerSmallIntParameter(int paramIndex, String paramType, String paramValue, String paramDirection) throws NumberFormatException, SQLException {
        this.debug("Parameter is int!");
        if (ServerPreparedStatementParameters.isInParameter(paramDirection)) {
            Integer theInteger = Integer.parseInt(paramValue);
            this.debug("");
            this.debug("Parameter paramIndex: " + paramIndex);
            this.debug("Parameter int value : " + theInteger);
            this.preparedStatement.setInt(paramIndex, theInteger);
            this.parameterValues.put(paramIndex, Integer.parseInt(paramValue));
        }
        this.registerOutParameter(paramIndex, paramType, paramDirection);
    }

    private void registerBitParameter(int paramIndex, String paramType, String paramValue, String paramDirection) throws SQLException {
        if (ServerPreparedStatementParameters.isInParameter(paramDirection)) {
            Boolean theBool = Boolean.valueOf(paramValue);
            this.preparedStatement.setBoolean(paramIndex, theBool);
            this.parameterValues.put(paramIndex, Boolean.parseBoolean(paramValue));
        }
        this.registerOutParameter(paramIndex, paramType, paramDirection);
    }

    private void registerDecimalOrNumericParameter(int paramIndex, String paramType, String paramValue, String paramDirection) throws SQLException {
        if (ServerPreparedStatementParameters.isInParameter(paramDirection)) {
            BigDecimal bigDecimal = new BigDecimal(paramValue);
            this.preparedStatement.setBigDecimal(paramIndex, bigDecimal);
            this.parameterValues.put(paramIndex, new BigDecimal(paramValue));
        }
        this.registerOutParameter(paramIndex, paramType, paramDirection);
    }

    private void registerCharParameter(int paramIndex, String paramType, String paramValue, String paramDirection) throws SQLException {
        if (ServerPreparedStatementParameters.isInParameter(paramDirection)) {
            this.debug("");
            this.debug("Parameter paramIndex   : " + paramIndex);
            this.debug("Parameter string value : " + paramValue);
            this.preparedStatement.setString(paramIndex, paramValue);
            this.parameterValues.put(paramIndex, paramValue);
        }
        this.registerOutParameter(paramIndex, paramType, paramDirection);
    }

    private void registerNullParameter(int paramIndex, String paramType, String paramDirection) throws SQLException {
        this.debug("BEFORE setNull " + paramIndex + " " + paramType);
        if (ServerPreparedStatementParameters.isInParameter(paramDirection)) {
            this.preparedStatement.setNull(paramIndex, JavaSqlConversion.fromSqlToJava(paramType));
            this.parameterValues.put(paramIndex, null);
        }
        this.registerOutParameter(paramIndex, paramType, paramDirection);
        this.debug("AFTER setNull");
    }

    private void registerOutParameter(int paramIndex, String paramType, String paramDirection) throws SQLException {
        if (ServerPreparedStatementParameters.isOutParameter(paramDirection)) {
            if (this.preparedStatement instanceof CallableStatement) {
                int sqlType = JavaSqlConversion.fromSqlToJava(paramType);
                ((CallableStatement)this.preparedStatement).registerOutParameter(paramIndex, sqlType);
            } else {
                throw new IllegalArgumentException("Illegal OUT parameter. PreparedStatement is not a CallableStatement (parameter index: " + paramIndex + ").");
            }
        }
    }

    public static boolean isInParameter(String parameterDirection) {
        Objects.requireNonNull(parameterDirection, "parameterDirection cannot be null!");
        return parameterDirection.equals("in") || parameterDirection.equals("inout");
    }

    public static boolean isOutParameter(String parameterDirection) {
        Objects.requireNonNull(parameterDirection, "parameterDirection cannot be null!");
        return parameterDirection.equals("out") || parameterDirection.equals("inout");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setCharacterStream(PreparedStatement preparedStatement, int parameterIndex, String paramValue) throws SQLException, IOException {
        DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(this.database);
        String blobId = paramValue;
        File blobsDir = databaseConfigurator.getBlobsDirectory(this.username);
        File clobFile = new File(String.valueOf(blobsDir.toString()) + File.separator + blobId);
        if (!clobFile.exists()) {
            throw new FileNotFoundException("Clob file does not exists for blob_id: " + blobId);
        }
        BufferedReader reader = null;
        this.readerList.add(reader);
        long theLength = -1L;
        if (Boolean.parseBoolean(this.htlmEncoding)) {
            File clobFileHtmlDecoded;
            block21: {
                clobFileHtmlDecoded = new File(clobFile + HTML_DECODED);
                this.blobsOrClobs.add(clobFileHtmlDecoded);
                try {
                    Throwable throwable = null;
                    Object var13_13 = null;
                    try {
                        BufferedReader br = new BufferedReader(new FileReader(clobFile));
                        try {
                            try (BufferedWriter writer = new BufferedWriter(new FileWriter(clobFileHtmlDecoded));){
                                String line = null;
                                while ((line = br.readLine()) != null) {
                                    line = HtmlConverter.fromHtml(line);
                                    writer.write(String.valueOf(line) + CR_LF);
                                }
                            }
                            if (br == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (br == null) throw throwable;
                            br.close();
                            throw throwable;
                        }
                        br.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                finally {
                    if (!KeepTempFilePolicyParms.KEEP_TEMP_FILE && !DEBUG) {
                        clobFile.delete();
                    }
                }
            }
            reader = new BufferedReader(new FileReader(clobFileHtmlDecoded));
            theLength = clobFileHtmlDecoded.length();
        } else {
            this.blobsOrClobs.add(clobFile);
            reader = new BufferedReader(new FileReader(clobFile));
            theLength = clobFile.length();
        }
        preparedStatement.setCharacterStream(parameterIndex, (Reader)reader, (int)theLength);
    }

    private void setBinaryStream(PreparedStatement preparedStatement, int parameterIndex, String paramValue) throws SQLException, IOException {
        DatabaseConfigurator databaseConfigurator = InjectedClassesStore.get().getDatabaseConfigurators().get(this.database);
        String blobId = paramValue;
        File blobsDir = databaseConfigurator.getBlobsDirectory(this.username);
        File blobFile = new File(String.valueOf(blobsDir.toString()) + File.separator + blobId);
        this.debug("before getFileFromParameter()");
        this.blobsOrClobs.add(blobFile);
        this.debug("before new BufferedInputStream(new FileInputStream(blobFile))");
        if (!blobFile.exists()) {
            throw new IllegalArgumentException("No Blob/Clob uploaded for blob_id. FIle does not exists: " + blobFile);
        }
        BufferedInputStream in = null;
        in = new BufferedInputStream(new FileInputStream(blobFile));
        long theLength = blobFile.length();
        this.inList.add(in);
        this.debug("before preparedStatement.setBinaryStream()");
        Connection connection = preparedStatement.getConnection();
        if (PostgreSqlUtil.isPostgreSqlStatementWithOID(connection, this.sql)) {
            this.debug("column is OID! " + parameterIndex);
            PostgreSqlUtil.setPostgreSqlParameterWithLargeObject(preparedStatement, parameterIndex, in, connection);
        } else {
            this.debug("column is NOT OID " + parameterIndex);
            preparedStatement.setBinaryStream(parameterIndex, (InputStream)in, (int)theLength);
        }
        this.debug("after preparedStatement.setBinaryStream()");
    }

    public List<Object> getParameterValues() {
        Collection<Object> collection = this.parameterValues.values();
        Vector<Object> values = new Vector<Object>();
        for (Object object : collection) {
            values.add(object);
        }
        return values;
    }

    public void close() {
        for (InputStream in : this.inList) {
            if (in == null) continue;
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (Reader reader : this.readerList) {
            if (reader == null) continue;
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (KeepTempFilePolicyParms.KEEP_TEMP_FILE || DEBUG) {
            System.err.println("WARNING: Blob file not deleted! KEEP_TEMP_FILE: " + KeepTempFilePolicyParms.KEEP_TEMP_FILE + " DEBUG: " + DEBUG);
            return;
        }
        for (File blobOrClob : this.blobsOrClobs) {
            blobOrClob.delete();
        }
    }

    public Map<Integer, String> getParameterTypes() {
        return this.parameterTypes;
    }

    public Map<Integer, String> getParameterStringValues() {
        return this.parameterStringValues;
    }

    public Map<Integer, AceQLParameter> getInOutStatementParameters() {
        return this.inOutStatementParameters;
    }

    protected void debug(String s) {
        if (DEBUG) {
            System.out.println(new java.util.Date() + " " + s);
        }
    }
}

