/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.sql.parameters;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.SystemUtils;
import org.kawanfw.sql.servlet.sql.AceQLParameter;
import org.kawanfw.sql.servlet.sql.dto.PrepStatementParamsHolder;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.HtmlConverter;

public class ServerPreparedStatementParametersUtil {
    private static boolean DEBUG = FrameworkDebug.isSet(ServerPreparedStatementParametersUtil.class);

    public static Map<Integer, AceQLParameter> buildParametersFromRequest(HttpServletRequest request) throws SQLException {
        String requestParamType;
        TreeMap<Integer, AceQLParameter> inOutStatementParameters = new TreeMap<Integer, AceQLParameter>();
        int i = 1;
        while ((requestParamType = request.getParameter("param_type_" + i)) != null && !requestParamType.isEmpty()) {
            String requestParamValue = request.getParameter("param_value_" + i);
            String parameterDirection = request.getParameter("param_direction_" + i);
            if (parameterDirection == null) {
                parameterDirection = "in";
            }
            if (!((parameterDirection = parameterDirection.toLowerCase()).equals("in") || parameterDirection.equals("out") || parameterDirection.equals("inout"))) {
                throw new IllegalArgumentException("Invalid direction for parameter of index " + i + ": " + parameterDirection);
            }
            String outParameterName = request.getParameter("out_param_name_" + i);
            inOutStatementParameters.put(i, new AceQLParameter(i, requestParamType, requestParamValue, parameterDirection, outParameterName));
            ServerPreparedStatementParametersUtil.debug("index: " + i + " / type " + requestParamType + " / direction: " + parameterDirection + " / value: " + requestParamValue);
            if (ServerPreparedStatementParametersUtil.isInParameter(parameterDirection) && requestParamValue == null) {
                throw new SQLException("No parameter value for IN parameter index " + i);
            }
            ++i;
        }
        return inOutStatementParameters;
    }

    public static Map<Integer, AceQLParameter> buildParametersFromHolder(PrepStatementParamsHolder prepStatementParamsHolder) {
        String parameterType;
        Objects.requireNonNull(prepStatementParamsHolder, "prepStatementParamsHolder cannot be null!");
        Map<String, String> holderStatementParameters = prepStatementParamsHolder.getStatementParameters();
        ServerPreparedStatementParametersUtil.debug();
        ServerPreparedStatementParametersUtil.debug("PreparedStatement parameters:");
        ServerPreparedStatementParametersUtil.debug(holderStatementParameters);
        HashMap<Integer, AceQLParameter> parameters = new HashMap<Integer, AceQLParameter>();
        int i = 1;
        while ((parameterType = holderStatementParameters.get("param_type_" + i)) != null) {
            String parameterValue = holderStatementParameters.get("param_value_" + i);
            parameterValue = HtmlConverter.fromHtml(parameterValue);
            String parameterDirection = "in";
            AceQLParameter aceQLParameter = new AceQLParameter(i, parameterType, parameterValue, parameterDirection, null);
            parameters.put(i, aceQLParameter);
            ++i;
        }
        ServerPreparedStatementParametersUtil.debug();
        ServerPreparedStatementParametersUtil.debug(parameters);
        return parameters;
    }

    public static boolean isInParameter(String parameterDirection) {
        Objects.requireNonNull(parameterDirection, "parameterDirection cannot be null!");
        return parameterDirection.equals("in") || parameterDirection.equals("inout");
    }

    private static void debug(Map<?, ?> map) {
        if (DEBUG) {
            ServerPreparedStatementParametersUtil.dump(new Date() + " " + map);
        }
    }

    private static void debug() {
        if (DEBUG) {
            ServerPreparedStatementParametersUtil.dump("" + new Date());
        }
    }

    public static void debug(Set<String> set) {
        if (DEBUG) {
            ServerPreparedStatementParametersUtil.dump(new Date() + " " + set);
        }
    }

    protected static void debug(String s) {
        if (DEBUG) {
            ServerPreparedStatementParametersUtil.dump(new Date() + " " + s);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dump(String string) {
        File file = ServerPreparedStatementParametersUtil.getDumpFile();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileWriter fw = new FileWriter(file, true);
                try {
                    block20: {
                        BufferedWriter bw = new BufferedWriter(fw);
                        try {
                            try (PrintWriter out = new PrintWriter(bw);){
                                out.println(string);
                            }
                            if (bw == null) break block20;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (bw == null) throw throwable;
                            bw.close();
                            throw throwable;
                        }
                        bw.close();
                    }
                    if (fw == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (fw == null) throw throwable;
                    fw.close();
                    throw throwable;
                }
                fw.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public static File getDumpFile() {
        String filename = SystemUtils.getUserHome() + File.separator + "aceql_dump.txt";
        File file = new File(filename);
        return file;
    }
}

