/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.ByteBuffer;
import java.util.Date;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.swing.Timer;

public class BeepUtil {
    public static void beep(double freq, final double millis) throws InterruptedException, LineUnavailableException {
        final Clip clip = AudioSystem.getClip();
        AudioFormat af = clip.getFormat();
        if (!af.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            throw new UnsupportedOperationException("Unknown encoding");
        }
        if (af.getSampleSizeInBits() != 16) {
            System.err.println("Weird sample size.  Dunno what to do with it.");
            return;
        }
        int bytesPerFrame = af.getFrameSize();
        double fps = af.getFrameRate();
        int frames = (int)(fps * (millis / 1000.0));
        ByteBuffer data = ByteBuffer.allocate(frames * bytesPerFrame);
        double freqFactor = 1.5707963267948966 * freq / fps;
        double ampFactor = 32767.0;
        int frame = 0;
        while (frame < frames) {
            short sample = (short)(ampFactor * Math.sin((double)frame * freqFactor));
            data.putShort(sample);
            ++frame;
        }
        clip.open(af, data.array(), 0, data.position());
        clip.addLineListener(new LineListener(){

            @Override
            public void update(LineEvent event) {
                if (event.getType().equals(LineEvent.Type.START)) {
                    Timer t = new Timer((int)millis + 1, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            clip.close();
                        }
                    });
                    t.setRepeats(false);
                    t.start();
                }
            }
        });
        clip.start();
        Thread.sleep((long)millis);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(new Date() + " Beginning...");
        BeepUtil.beep(750.0, 2000.0);
        System.out.println(new Date() + " End.");
    }
}

