/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.util.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedRollingPolicy;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.Map;
import org.kawanfw.sql.api.server.logging.LoggerCreator;
import org.kawanfw.sql.servlet.util.logging.GenericLoggerCreatorUtil;
import org.kawanfw.sql.servlet.util.logging.LoggerCreatorBuilderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericLoggerCreator
implements LoggerCreator {
    private Logger logger;
    private Map<String, String> elements;

    GenericLoggerCreator(LoggerCreatorBuilderImpl builder) {
        String name = builder.name;
        String logDirectory = builder.logDirectory.toString();
        if (!logDirectory.endsWith(File.separator)) {
            logDirectory = String.valueOf(logDirectory) + File.separator;
        }
        String fileNamePattern = builder.fileNamePattern;
        String pattern = builder.pattern;
        long maxFileSize = builder.maxFileSize;
        long totalSizeCap = builder.totalSizeCap;
        boolean displayOnConsole = builder.displayOnConsole;
        boolean displayLogStatusMessages = builder.displayLogStatusMessages;
        this.elements = GenericLoggerCreatorUtil.createElements(name, logDirectory, fileNamePattern, maxFileSize, totalSizeCap, displayOnConsole, displayLogStatusMessages);
        int maxHistory = 365;
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        RollingFileAppender rollingFileAppender = new RollingFileAppender();
        rollingFileAppender.setAppend(true);
        rollingFileAppender.setContext((Context)context);
        SizeAndTimeBasedRollingPolicy rollingPolicy = new SizeAndTimeBasedRollingPolicy();
        rollingPolicy.setContext((Context)context);
        rollingPolicy.setFileNamePattern(String.valueOf(logDirectory) + fileNamePattern);
        rollingPolicy.setMaxHistory(maxHistory);
        rollingPolicy.setTotalSizeCap(new FileSize(totalSizeCap));
        rollingPolicy.setMaxFileSize(new FileSize(maxFileSize));
        rollingPolicy.setParent((FileAppender)rollingFileAppender);
        rollingPolicy.start();
        rollingFileAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setPattern(pattern);
        encoder.setContext((Context)context);
        encoder.start();
        rollingFileAppender.setEncoder((Encoder)encoder);
        rollingFileAppender.start();
        ConsoleAppender logConsoleAppender = new ConsoleAppender();
        logConsoleAppender.setContext((Context)context);
        logConsoleAppender.setName("console");
        logConsoleAppender.setEncoder((Encoder)encoder);
        logConsoleAppender.start();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(byteArrayOutputStream);
        StatusPrinter.setPrintStream((PrintStream)ps);
        StatusPrinter.print((Context)context);
        this.logger = context.getLogger(name);
        ((ch.qos.logback.classic.Logger)this.logger).addAppender((Appender)rollingFileAppender);
        ((ch.qos.logback.classic.Logger)this.logger).setAdditive(false);
        if (displayOnConsole) {
            ((ch.qos.logback.classic.Logger)this.logger).addAppender((Appender)logConsoleAppender);
        }
        if (displayLogStatusMessages) {
            System.err.println(byteArrayOutputStream.toString());
        }
    }

    public static Builder newBuilder() {
        return new LoggerCreatorBuilderImpl();
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public Map<String, String> getElements() {
        return this.elements;
    }

    public static interface Builder {
        public Builder name(String var1);

        public Builder fileNamePattern(String var1);

        public Builder pattern(String var1);

        public Builder logDirectory(File var1);

        public Builder maxFileSize(long var1);

        public Builder totalSizeCap(long var1);

        public Builder displayOnConsole(boolean var1);

        public Builder displayLogStatusMessages(boolean var1);

        public GenericLoggerCreator build();
    }
}

