/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.util.logging;

import java.io.File;
import java.util.Objects;
import org.apache.commons.lang3.SystemUtils;
import org.kawanfw.sql.servlet.util.logging.GenericLoggerCreator;

public class LoggerCreatorBuilderImpl
implements GenericLoggerCreator.Builder {
    static final long KB = 1024L;
    static final long MB = 0x100000L;
    static final long GB = 0x40000000L;
    public static final File DEFAULT_LOG_DIRECTORY = new File(String.valueOf(SystemUtils.USER_HOME) + File.separator + ".kawansoft" + File.separator + "log");
    public static final String DEFAULT_PATTERN = "%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n";
    public static final long DEFAULT_MAX_SIZE = 314572800L;
    public static final long DEFAULT_TOTAL_SIZE_CAP = 0x780000000L;
    public static final String SHORT_PATTERN = "%msg%n";
    String name = null;
    String fileNamePattern = null;
    File logDirectory = DEFAULT_LOG_DIRECTORY;
    String pattern = "%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n";
    long maxFileSize = 314572800L;
    long totalSizeCap = 0x780000000L;
    boolean displayOnConsole = false;
    boolean displayLogStatusMessages = false;

    @Override
    public GenericLoggerCreator.Builder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public GenericLoggerCreator.Builder fileNamePattern(String fileNamePattern) {
        this.fileNamePattern = fileNamePattern;
        return this;
    }

    @Override
    public GenericLoggerCreator.Builder logDirectory(File logDirectory) {
        this.logDirectory = logDirectory;
        return this;
    }

    @Override
    public GenericLoggerCreator.Builder pattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    @Override
    public GenericLoggerCreator.Builder maxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
        return this;
    }

    @Override
    public GenericLoggerCreator.Builder totalSizeCap(long totalSizeCap) {
        this.totalSizeCap = totalSizeCap;
        return this;
    }

    @Override
    public GenericLoggerCreator.Builder displayOnConsole(boolean displayOnConsole) {
        this.displayOnConsole = displayOnConsole;
        return this;
    }

    @Override
    public GenericLoggerCreator.Builder displayLogStatusMessages(boolean displayLogStatusMessages) {
        this.displayLogStatusMessages = displayLogStatusMessages;
        return this;
    }

    @Override
    public GenericLoggerCreator build() {
        boolean created;
        Objects.requireNonNull(this.name, "name cannnot be null!");
        Objects.requireNonNull(this.logDirectory, "logDirectory cannnot be null!");
        if (!this.logDirectory.exists() && !(created = this.logDirectory.mkdirs())) {
            throw new IllegalArgumentException("The log directory can not be created: " + this.logDirectory);
        }
        Objects.requireNonNull(this.name, "name cannnot be null!");
        Objects.requireNonNull(this.fileNamePattern, "fileNamePattern cannnot be null!");
        Objects.requireNonNull(this.pattern, "pattern cannnot be null!");
        if (this.maxFileSize < 0x100000L) {
            throw new IllegalArgumentException("maxFileSize must be > 1 MB");
        }
        if (this.totalSizeCap < this.maxFileSize) {
            throw new IllegalArgumentException("totalSizeCap must be >= maxFileSize");
        }
        GenericLoggerCreator genericLoggerCreator = new GenericLoggerCreator(this);
        return genericLoggerCreator;
    }
}

