/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.util.logging;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.SystemUtils;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileUtil;
import org.kawanfw.sql.servlet.util.logging.LoggerCreatorBuilderImpl;
import org.kawanfw.sql.util.FrameworkDebug;

public class LoggerCreatorProperties {
    private static boolean DEBUG = FrameworkDebug.isSet(LoggerCreatorProperties.class);
    private static final String CONF_DIR = String.valueOf(SystemUtils.USER_HOME) + File.separator + ".kawansoft" + File.separator + "conf" + File.separator;
    private Properties properties;
    private String fileNamePattern = null;
    private File logDirectory = LoggerCreatorBuilderImpl.DEFAULT_LOG_DIRECTORY;
    private String pattern = "%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n";
    private long maxFileSize = 314572800L;
    private long totalSizeCap = 0x780000000L;
    private boolean displayOnConsole = false;
    private boolean displayLogStatusMessages = false;

    public Properties getProperties() {
        return this.properties;
    }

    public String getFileNamePattern() {
        return this.fileNamePattern;
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public String getPattern() {
        return this.pattern;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public long getTotalSizeCap() {
        return this.totalSizeCap;
    }

    public boolean isDisplayOnConsole() {
        return this.displayOnConsole;
    }

    public boolean isDisplayLogStatusMessages() {
        return this.displayLogStatusMessages;
    }

    private LoggerCreatorProperties(Properties properties) {
        this.properties = properties;
    }

    private void set() {
        if (this.properties.get("fileNamePattern") != null) {
            this.fileNamePattern = (String)this.properties.get("fileNamePattern");
        }
        if (this.properties.get("logDirectory") != null && !((String)this.properties.get("logDirectory")).trim().isEmpty()) {
            this.logDirectory = new File((String)this.properties.get("logDirectory"));
            this.logDirectory.mkdirs();
        }
        if (this.properties.get("pattern") != null) {
            this.pattern = (String)this.properties.get("pattern");
        }
        if (this.properties.get("maxFileSize") != null) {
            String maxFileSizeStr = (String)this.properties.get("maxFileSize");
            this.maxFileSize = Long.parseLong(maxFileSizeStr);
        }
        if (this.properties.get("totalSizeCap") != null) {
            String totalSizeCapStr = (String)this.properties.get("totalSizeCap");
            this.totalSizeCap = Long.parseLong(totalSizeCapStr);
        }
        this.displayOnConsole = Boolean.parseBoolean((String)this.properties.get("displayOnConsole"));
        this.displayLogStatusMessages = Boolean.parseBoolean((String)this.properties.get("displayLogStatusMessages"));
    }

    public static LoggerCreatorProperties getFileBasedProperties(String loggerProperties) throws IllegalArgumentException, IOException {
        Objects.requireNonNull(loggerProperties, "loggerProperties cannot be null!");
        File file = new File(String.valueOf(CONF_DIR) + loggerProperties + ".properties");
        LoggerCreatorProperties.debug("loggerProperties File: " + file);
        if (!file.exists()) {
            return null;
        }
        Properties properties = PropertiesFileUtil.getProperties(file);
        LoggerCreatorProperties loggerCreatorProperties = new LoggerCreatorProperties(properties);
        loggerCreatorProperties.set();
        return loggerCreatorProperties;
    }

    private static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

