/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.servlet.util.logging;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Date;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.kawanfw.sql.api.server.firewall.trigger.JsonLoggerSqlFirewallTrigger;
import org.kawanfw.sql.servlet.util.logging.LoggerCreatorBuilderImpl;
import org.kawanfw.sql.servlet.util.logging.StringFlattener;
import org.kawanfw.sql.util.FrameworkDebug;
import org.slf4j.Logger;

public class LoggerWrapper {
    private static boolean DEBUG = FrameworkDebug.isSet(JsonLoggerSqlFirewallTrigger.class);
    public static String CR_LF = System.getProperty("line.separator");

    public static void log(Logger logger, String message) {
        String messageNew = LoggerWrapper.flattenIfNecessary(message);
        logger.info(messageNew);
    }

    public static void logError(Logger logger, String message) {
        String messageNew = LoggerWrapper.flattenIfNecessary(message);
        logger.error(messageNew);
    }

    public static void log(Logger logger, String message, Throwable throwable) {
        String messageNew = message;
        try {
            if (messageNew == null) {
                messageNew = "";
            }
            if (!messageNew.endsWith(" ")) {
                messageNew = String.valueOf(messageNew) + " ";
            }
            messageNew = LoggerWrapper.flattenIfNecessary(messageNew);
            StringFlattener stringFlattener = new StringFlattener(ExceptionUtils.getStackTrace((Throwable)throwable));
            String flattenException = stringFlattener.flatten();
            if (DEBUG) {
                String thePath = LoggerCreatorBuilderImpl.DEFAULT_LOG_DIRECTORY + File.separator + "LoggerWrapper_debug.txt";
                Files.write(Paths.get(thePath, new String[0]), (String.valueOf(messageNew) + flattenException + CR_LF).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            logger.error(String.valueOf(messageNew) + flattenException);
        }
        catch (Throwable throwable2) {
            logger.error("ACEQL HTTP CAN NOT FLATTEN EXCEPTION IN LOG:");
            logger.error(messageNew, throwable2);
        }
    }

    private static String flattenIfNecessary(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        String messageNew = message;
        try {
            StringFlattener stringFlattener = new StringFlattener(messageNew);
            messageNew = stringFlattener.flatten();
        }
        catch (Throwable throwable) {
            System.out.println("CANNOT FLAT MESSAGE:");
            throwable.printStackTrace();
            return messageNew;
        }
        return messageNew;
    }

    private static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

