/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.tomcat;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.tomcat.jdbc.pool.ConnectionPool;
import org.apache.tomcat.jdbc.pool.JdbcInterceptor;
import org.apache.tomcat.jdbc.pool.PooledConnection;
import org.kawanfw.sql.api.server.connectionstore.ConnectionKey;
import org.kawanfw.sql.servlet.connection.ConnectionStore;
import org.kawanfw.sql.servlet.injection.properties.ConfPropertiesUtil;
import org.kawanfw.sql.util.FrameworkDebug;

public class AceQLJdbcInterceptor
extends JdbcInterceptor {
    public static boolean DEBUG = FrameworkDebug.isSet(AceQLJdbcInterceptor.class);

    public AceQLJdbcInterceptor() {
        this.debug("AceQLJdbcInterceptor instance creation.");
    }

    public void reset(ConnectionPool parent, PooledConnection con) {
        if (con != null) {
            Connection connection = con.getConnection();
            this.debug("AceQLJdbcInterceptor. reset call: connection borrowed from pool: " + connection);
        } else {
            this.debug("AceQLJdbcInterceptor. reset call: connection borrowed from pool. con is null!");
        }
    }

    public void disconnected(ConnectionPool parent, PooledConnection con, boolean finalizing) {
        try {
            if (ConfPropertiesUtil.isStatelessMode()) {
                this.debug("AceQLJdbcInterceptor. Stateless mode. Nothing to do.");
                return;
            }
            if (con == null) {
                this.debug("Can not intercept Connection to use for cleaning our ConnectionStore: PooledConnection is null!");
            }
            this.debug("AceQLJdbcInterceptor. Clean ConnectionStore for intercepted connection...");
            Connection connection = con.getConnection();
            if (connection == null) {
                this.debug("AceQLJdbcInterceptor. Current Connection is null! Nothing to do.");
                return;
            }
            Map<ConnectionKey, Connection> map = ConnectionStore.getConnectionMap();
            Set<ConnectionKey> set = map.keySet();
            if (set == null) {
                this.debug("AceQLJdbcInterceptor. ConnectionStore Set<ConnectionKey> is null. Nothing to do.");
                return;
            }
            if (set.isEmpty()) {
                this.debug("AceQLJdbcInterceptor. ConnectionStore Set<ConnectionKey> is empty. Nothing to do.");
                return;
            }
            for (Map.Entry<ConnectionKey, Connection> entry : map.entrySet()) {
                Connection unwrappedStoredConnection = this.getUnwrappedConnection(entry.getValue());
                if (unwrappedStoredConnection != null) {
                    ConnectionKey connectionKey = entry.getKey();
                    this.debug("AceQLJdbcInterceptor. JdbcInterceptorTest connection.toString(): " + connection.toString());
                    this.debug("AceQLJdbcInterceptor. unwrappedStoredConnection.toString() : " + unwrappedStoredConnection.toString());
                    if (connection.equals(unwrappedStoredConnection)) {
                        ConnectionStore.remove(connectionKey);
                        this.debug("AceQLJdbcInterceptor. ConnectionStore all removed for connectionKey: " + connectionKey);
                        continue;
                    }
                    this.debug("AceQLJdbcInterceptor. Current connection does not correspond to connectionKey: " + connectionKey);
                    continue;
                }
                this.debug("AceQLJdbcInterceptor. connectionKey is null!");
            }
        }
        catch (Exception e) {
            System.err.println(new Date() + " AceQLJdbcInterceptor Failure:");
            e.printStackTrace();
        }
    }

    public Connection getUnwrappedConnection(Connection connection) throws SQLException {
        if (connection instanceof javax.sql.PooledConnection) {
            Connection actual = ((javax.sql.PooledConnection)((Object)connection)).getConnection();
            return actual;
        }
        return connection;
    }

    private void debug(String s) {
        if (DEBUG) {
            System.err.println(new Date() + " " + s);
        }
    }
}

