/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.tomcat;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.kawanfw.sql.api.server.DatabaseConfigurationException;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.SqlTag;

public class PoolPropertiesCreator {
    private static boolean DEBUG = FrameworkDebug.isSet(PoolPropertiesCreator.class);
    private Properties properties = null;
    private Class<?> theClass = null;
    private Map<String, Class<?>[]> methodNamesAndParms = null;
    private Object theObject = null;
    private String database = null;

    public PoolPropertiesCreator(Properties properties, String database) {
        this.properties = properties;
        this.database = database;
    }

    public PoolProperties create() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException, SQLException {
        this.theClass = PoolProperties.class;
        this.theObject = new PoolProperties();
        Method[] allMethods = this.theClass.getDeclaredMethods();
        Field[] fieldsArray = this.theClass.getDeclaredFields();
        HashSet<String> fields = new HashSet<String>();
        AccessibleObject[] accessibleObjectArray = fieldsArray;
        int n = fieldsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field theField = accessibleObjectArray[n2];
            String fieldName = theField.getName();
            fields.add(fieldName);
            ++n2;
        }
        this.methodNamesAndParms = new HashMap<String, Class<?>[]>();
        accessibleObjectArray = allMethods;
        n = allMethods.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject m = accessibleObjectArray[n2];
            String methodName = ((Method)m).getName();
            Class<?>[] pType = ((Method)m).getParameterTypes();
            this.methodNamesAndParms.put(methodName, pType);
            ++n2;
        }
        Enumeration<?> e = this.properties.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            String propertyValue = this.properties.getProperty(propertyName);
            if (propertyValue != null) {
                propertyValue = propertyValue.trim();
            }
            if (!(propertyName = propertyName.trim()).startsWith(String.valueOf(this.database) + ".")) continue;
            propertyName = StringUtils.substringAfter((String)propertyName, (String)(String.valueOf(this.database) + "."));
            this.debug("property.name: " + propertyName);
            if (!fields.contains(propertyName)) continue;
            try {
                this.callMethod(propertyName, propertyValue);
            }
            catch (NumberFormatException e1) {
                throw new DatabaseConfigurationException("The " + propertyName + " value is not numeric: " + propertyValue);
            }
        }
        PoolProperties poolProperties = (PoolProperties)this.theObject;
        return poolProperties;
    }

    private void callMethod(String propertyName, String propertyValue) throws SecurityException, NoSuchMethodException, NumberFormatException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SQLException {
        String theMethod = "set" + StringUtils.capitalize((String)propertyName);
        this.debug("theMethod: " + theMethod);
        String propertyValueUpdated = propertyValue;
        String propertyValueToDisplay = propertyValue;
        if (propertyName.equals("password")) {
            propertyValueToDisplay = "********";
        }
        Class<?>[] pType = this.methodNamesAndParms.get(theMethod);
        System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> " + propertyName + " = " + propertyValueToDisplay);
        Method main = this.theClass.getDeclaredMethod(theMethod, pType);
        if (pType[0] == Long.TYPE) {
            main.invoke(this.theObject, Long.parseLong(propertyValueUpdated));
        } else if (pType[0] == String.class) {
            main.invoke(this.theObject, propertyValueUpdated);
        } else if (pType[0] == Boolean.TYPE) {
            main.invoke(this.theObject, Boolean.parseBoolean(propertyValueUpdated));
        } else if (pType[0] == Boolean.class) {
            main.invoke(this.theObject, Boolean.valueOf(propertyValueUpdated));
        } else if (pType[0] == Integer.TYPE) {
            main.invoke(this.theObject, Integer.parseInt(propertyValueUpdated));
        } else {
            throw new DatabaseConfigurationException("Invalid Connection Pool property: " + propertyName);
        }
    }

    private void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

