/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.tomcat;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.SqlTag;

public class SystemPropUpdater {
    private static boolean DEBUG = FrameworkDebug.isSet(SystemPropUpdater.class);
    private Properties properties = null;

    public SystemPropUpdater(Properties properties) {
        this.properties = properties;
    }

    public void update() {
        Enumeration<?> enumeration = this.properties.propertyNames();
        if (enumeration.hasMoreElements()) {
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " Setting System Properties:");
        }
        while (enumeration.hasMoreElements()) {
            String theValue;
            String property = (String)enumeration.nextElement();
            if (property.startsWith("systemSetProperty.")) {
                theValue = this.properties.getProperty(property);
                String systemProperty = StringUtils.substringAfter((String)property, (String)".");
                SystemPropUpdater.debug("property      : " + property);
                SystemPropUpdater.debug("systemProperty: " + systemProperty);
                if (theValue != null && !theValue.isEmpty()) {
                    theValue = theValue.trim();
                    System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> " + systemProperty + " = " + theValue);
                    System.setProperty(systemProperty, theValue);
                }
            }
            if (!property.equals("systemClearProperty") || (theValue = this.properties.getProperty(property)) == null || theValue.isEmpty()) continue;
            theValue = theValue.trim();
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> " + theValue + " clear ");
            System.clearProperty(theValue);
        }
    }

    private static void debug(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }
}

