/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.tomcat;

import java.io.File;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.lang3.StringUtils;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.http2.Http2Protocol;
import org.kawanfw.sql.api.server.DatabaseConfigurationException;
import org.kawanfw.sql.util.SqlTag;

public class TomcatConnectorsUpdater {
    private Tomcat tomcat = null;
    private Properties properties = null;

    public TomcatConnectorsUpdater(Tomcat tomcat, Properties properties) {
        this.properties = properties;
        this.tomcat = tomcat;
    }

    public void updateToHttp2Protocol() throws SQLException {
        String updateToHttp2ProtocolStr = this.properties.getProperty("updateToHttp2Protocol");
        boolean updateToHttp2Protocol = Boolean.parseBoolean(updateToHttp2ProtocolStr);
        boolean propertyValue = updateToHttp2Protocol;
        if (propertyValue) {
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " Protocol updated to HTTP/2");
            this.tomcat.getConnector().addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
        }
    }

    public void setConnectorValues() {
        Enumeration<?> enumeration = this.properties.propertyNames();
        if (enumeration.hasMoreElements()) {
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " Setting Default Connector base attributes:");
        }
        while (enumeration.hasMoreElements()) {
            String property = (String)enumeration.nextElement();
            if (!property.startsWith("connector.")) continue;
            String theValue = this.properties.getProperty(property);
            String tomcatProperty = StringUtils.substringAfter((String)property, (String)"connector.");
            if (theValue == null || theValue.isEmpty()) continue;
            theValue = theValue.trim();
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> " + tomcatProperty + " = " + theValue);
            this.tomcat.getConnector().setProperty(tomcatProperty, theValue);
        }
    }

    public void setDefaultConnectorSslValues() throws DatabaseConfigurationException, ConnectException {
        String sslConnectorSSLEnabled = this.properties.getProperty("sslConnector.SSLEnabled");
        if (sslConnectorSSLEnabled != null) {
            sslConnectorSSLEnabled = sslConnectorSSLEnabled.trim();
        }
        if (sslConnectorSSLEnabled == null || !sslConnectorSSLEnabled.trim().equals("true")) {
            return;
        }
        String scheme = this.getMandatoryPropertyValue("sslConnector.scheme");
        if (!scheme.equals("https")) {
            throw new DatabaseConfigurationException("The property sslConnector.https value must be \"https\" in properties file. Please correct and retry.");
        }
        this.checkMandatoryValues();
        Connector defaultConnector = this.tomcat.getConnector();
        defaultConnector.setScheme(scheme);
        defaultConnector.setSecure(true);
        this.setValuesFromEnumaration(defaultConnector);
    }

    private void checkMandatoryValues() throws DatabaseConfigurationException {
        String keyStoreFileStr = this.getMandatoryPropertyValue("sslConnector.keystoreFile");
        File keystoreFile = new File(keyStoreFileStr);
        if (!keystoreFile.exists()) {
            throw new DatabaseConfigurationException("The file specified by sslConnector.keystoreFile property does not exists: " + keystoreFile + ". " + "Please correct and retry.");
        }
        String keystorePass = this.getMandatoryPropertyValue("sslConnector.keystorePass");
        String keyPass = this.getMandatoryPropertyValue("sslConnector.keyPass");
        String keyAlias = this.getMandatoryPropertyValue("sslConnector.keyAlias");
    }

    private void setValuesFromEnumaration(Connector defaultConnector) {
        Enumeration<?> enumeration = this.properties.propertyNames();
        if (enumeration.hasMoreElements()) {
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " Setting Default Connector SSL attributes:");
        }
        while (enumeration.hasMoreElements()) {
            String property = (String)enumeration.nextElement();
            if (!property.startsWith("sslConnector.") || property.equals("sslConnector.scheme")) continue;
            String theValue = this.properties.getProperty(property);
            String tomcatProperty = StringUtils.substringAfter((String)property, (String)"sslConnector.");
            if (theValue == null || theValue.isEmpty()) continue;
            theValue = theValue.trim();
            defaultConnector.setProperty(tomcatProperty, theValue);
            if (property.equals("sslConnector.keyPass") || property.equals("sslConnector.keystorePass")) {
                theValue = "********";
            }
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> " + tomcatProperty + " = " + theValue);
        }
    }

    private String getMandatoryPropertyValue(String propertyName) throws DatabaseConfigurationException {
        String properteyValue = this.properties.getProperty(propertyName);
        if (properteyValue == null || properteyValue.isEmpty()) {
            throw new DatabaseConfigurationException("SSL activation. Property " + propertyName + " name is not defined or has empty value in properties file. " + "Please correct and retry.");
        }
        properteyValue = properteyValue.trim();
        return properteyValue;
    }
}

