/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.tomcat;

import java.io.File;
import org.apache.catalina.Context;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;

public class TomcatFilterUtil {
    protected TomcatFilterUtil() {
    }

    public static void addFilterToContext(Context rootCtx) {
        String filterName = "CorsFilter";
        String filterClass = "org.apache.catalina.filters.CorsFilter";
        FilterDef filterDef = new FilterDef();
        filterDef.setFilterName(filterName);
        filterDef.setFilterClass(filterClass);
        filterDef.addInitParameter("cors.allowed.origins", "*");
        filterDef.addInitParameter("cors.allowed.methods", "GET,POST,HEAD,OPTIONS,PUT");
        filterDef.addInitParameter("cors.allowed.headers", "Content-Type,X-Requested-With,accept,Origin,Access-Control-Request-Method,Access-Control-Request-Headers");
        FilterMap filterMap = new FilterMap();
        filterMap.setFilterName(filterName);
        filterMap.addURLPattern("/*");
        rootCtx.addFilterDef(filterDef);
        rootCtx.addFilterMap(filterMap);
    }

    public static void main(String[] args) throws Exception {
        Tomcat tomcat = new Tomcat();
        Context rootCtx = tomcat.addContext("", new File("c:\\tmp").getAbsolutePath());
        TomcatFilterUtil.addFilterToContext(rootCtx);
    }
}

