/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.tomcat;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.kawanfw.sql.api.server.DatabaseConfigurationException;
import org.kawanfw.sql.servlet.ServerSqlManager;
import org.kawanfw.sql.servlet.injection.properties.AdvancedServletAceQLCallNameGetter;
import org.kawanfw.sql.servlet.injection.properties.ConfProperties;
import org.kawanfw.sql.servlet.injection.properties.ConfPropertiesManager;
import org.kawanfw.sql.servlet.injection.properties.ConfPropertiesStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileStore;
import org.kawanfw.sql.servlet.injection.properties.PropertiesFileUtil;
import org.kawanfw.sql.tomcat.SystemPropUpdater;
import org.kawanfw.sql.tomcat.TomcatConnectorsUpdater;
import org.kawanfw.sql.tomcat.TomcatFilterUtil;
import org.kawanfw.sql.tomcat.TomcatSqlModeStore;
import org.kawanfw.sql.tomcat.TomcatStarterMessages;
import org.kawanfw.sql.tomcat.TomcatStarterUtil;
import org.kawanfw.sql.tomcat.util.PortSemaphoreFile;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.SqlTag;

public class TomcatStarter {
    private static boolean DEBUG = FrameworkDebug.isSet(TomcatStarter.class);
    public static String CR_LF = System.getProperty("line.separator");
    private File propertiesFile = null;
    private String host = null;
    private int port = -1;
    public static final String MASKED_PASSWORD = "********";

    public TomcatStarter(String host, int port, File propertiesFile) {
        if (host == null) {
            throw new IllegalArgumentException("Server host is null!");
        }
        if (port <= 0) {
            throw new IllegalArgumentException("Server port <= 0!");
        }
        if (propertiesFile == null) {
            throw new IllegalArgumentException("Server properties file is null!");
        }
        this.host = host;
        this.port = port;
        this.propertiesFile = propertiesFile;
    }

    public void startTomcat() throws IOException, ConnectException, DatabaseConfigurationException, LifecycleException, SQLException {
        Tomcat tomcat = new Tomcat();
        try {
            this.startTomcat(tomcat);
        }
        finally {
            try {
                tomcat.stop();
                tomcat.destroy();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                e.printStackTrace();
            }
        }
    }

    private void startTomcat(Tomcat tomcat) throws IOException, ConnectException, LifecycleException, MalformedURLException, DatabaseConfigurationException, SQLException {
        TomcatSqlModeStore.setTomcatEmbedded(true);
        PropertiesFileStore.set(this.propertiesFile);
        TomcatStarterMessages.printBeginMessage();
        System.out.println(TomcatStarterUtil.getJavaInfo());
        System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " " + "Using Properties File: ");
        System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> " + this.propertiesFile);
        Properties properties = PropertiesFileUtil.getProperties(this.propertiesFile);
        TomcatStarter.debug("");
        if (DEBUG) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!key.contains("password")) continue;
                TomcatStarter.debug(" In startTomcat --> key / value: " + key + " / " + value);
            }
        }
        String tomcatLoggingLevel = properties.getProperty("tomcatLoggingLevel");
        String level = "SEVERE";
        if (tomcatLoggingLevel != null && !tomcatLoggingLevel.isEmpty()) {
            level = tomcatLoggingLevel;
        }
        Logger.getLogger("org.apache").setLevel(Level.parse(level));
        String flushEachResultSetRow = properties.getProperty("flushEachResultSetRow");
        if (flushEachResultSetRow == null || flushEachResultSetRow.isEmpty()) {
            flushEachResultSetRow = "true";
        }
        System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " " + "Setting Internal Properties: ");
        System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> tomcatLoggingLevel = " + level);
        System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> flushEachResultSetRow = " + Boolean.parseBoolean(flushEachResultSetRow));
        TomcatSqlModeStore.setTomcatEmbedded(true);
        tomcat.setSilent(true);
        tomcat.setBaseDir(this.getBaseDir().getAbsolutePath());
        tomcat.setHostname(this.host);
        tomcat.setPort(this.port);
        this.tomcatBeforeStartSetConnectors(tomcat, properties);
        Context rootCtx = this.tomcatBeforeStartSetContext(tomcat, properties);
        TomcatStarterUtil.createAndStoreDataSources(properties);
        TomcatStarterUtil.addServlets(properties, rootCtx);
        tomcat.start();
        this.tomcatAfterStart(tomcat, properties);
    }

    private void tomcatAfterStart(Tomcat tomcat, Properties properties) throws MalformedURLException, IOException, SQLException {
        PortSemaphoreFile portSemaphoreFile;
        Connector defaultConnector = tomcat.getConnector();
        boolean result = this.testServlet(properties, defaultConnector.getScheme());
        if (!result) {
            throw new IOException(String.valueOf(SqlTag.SQL_PRODUCT_START_FAILURE) + " " + "Can not call the AceQL ManagerServlet");
        }
        TomcatStarterMessages.printFinalOkMessage(this.port);
        do {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((portSemaphoreFile = new PortSemaphoreFile(this.port)).exists());
    }

    private static void queryExecutorHook() {
        ArrayList classNames = new ArrayList();
        System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " Allowed ServerQueryExecutor: ");
        for (String className : classNames) {
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "   -> " + className);
        }
    }

    private Context tomcatBeforeStartSetContext(Tomcat tomcat, Properties properties) throws IOException, SQLException {
        Context rootCtx = tomcat.addContext("", this.getBaseDir().getAbsolutePath());
        TomcatFilterUtil.addFilterToContext(rootCtx);
        this.addAceqlServlet(properties, rootCtx);
        return rootCtx;
    }

    private void tomcatBeforeStartSetConnectors(Tomcat tomcat, Properties properties) throws DatabaseConfigurationException, ConnectException, SQLException {
        tomcat.getConnector().setProperty("bindOnInit", "false");
        SystemPropUpdater systemPropUpdater = new SystemPropUpdater(properties);
        systemPropUpdater.update();
        TomcatConnectorsUpdater tomcatConnectorsUpdater = new TomcatConnectorsUpdater(tomcat, properties);
        tomcatConnectorsUpdater.updateToHttp2Protocol();
        tomcatConnectorsUpdater.setConnectorValues();
        tomcatConnectorsUpdater.setDefaultConnectorSslValues();
    }

    public void addAceqlServlet(Properties properties, Context rootCtx) throws IOException, SQLException {
        if (properties == null) {
            throw new IllegalArgumentException("properties can not be null");
        }
        AdvancedServletAceQLCallNameGetter advancedServletAceQLCallNameGetter = new AdvancedServletAceQLCallNameGetter();
        String aceQLManagerServletCallName = advancedServletAceQLCallNameGetter.getName();
        Wrapper wrapper = Tomcat.addServlet((Context)rootCtx, (String)aceQLManagerServletCallName, (Servlet)new ServerSqlManager());
        wrapper.setAsyncSupported(true);
        rootCtx.addServletMappingDecoded("/*", aceQLManagerServletCallName);
        ConfPropertiesManager confPropertiesManager = new ConfPropertiesManager(properties);
        ConfProperties confProperties = confPropertiesManager.createConfProperties();
        ConfPropertiesStore.set(confProperties);
    }

    public boolean testServlet(Properties properties, String scheme) throws MalformedURLException, IOException, SQLException {
        String aceQLManagerServletCallName;
        AdvancedServletAceQLCallNameGetter advancedServletAceQLCallNameGetter = new AdvancedServletAceQLCallNameGetter();
        String serverSqlManagerUrlPattern = aceQLManagerServletCallName = advancedServletAceQLCallNameGetter.getName();
        if (!(serverSqlManagerUrlPattern = serverSqlManagerUrlPattern.trim()).startsWith("/")) {
            serverSqlManagerUrlPattern = "/" + serverSqlManagerUrlPattern;
        }
        String url = String.valueOf(scheme) + "://" + this.host + ":" + this.port + serverSqlManagerUrlPattern;
        String loadAceQLManagerServletOnStartup = properties.getProperty("loadAceQLManagerServletOnStartup", "true");
        if (loadAceQLManagerServletOnStartup == null || loadAceQLManagerServletOnStartup.isEmpty() || !Boolean.parseBoolean(loadAceQLManagerServletOnStartup)) {
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " URL for client side: " + url);
            return true;
        }
        String serverSqlManagerstatus = this.callServerSqlManagerServlet(url);
        if (serverSqlManagerstatus.contains("\"OK\"")) {
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " URL for client side (tested): " + url);
            return true;
        }
        return false;
    }

    private String callServerSqlManagerServlet(String url) throws MalformedURLException, IOException {
        String inputLine;
        URL theUrl = new URL(url);
        URLConnection urLconnection = theUrl.openConnection();
        BufferedReader br = new BufferedReader(new InputStreamReader(urLconnection.getInputStream()));
        String serverSqlManagerstatus = "";
        while ((inputLine = br.readLine()) != null) {
            serverSqlManagerstatus = String.valueOf(serverSqlManagerstatus) + inputLine + CR_LF;
        }
        br.close();
        return serverSqlManagerstatus;
    }

    private File getBaseDir() {
        String userHome = System.getProperty("user.home");
        if (!userHome.endsWith(File.separator)) {
            userHome = String.valueOf(userHome) + File.separator;
        }
        File baseDir = new File(String.valueOf(userHome) + ".kawansoft" + File.separator + "tomcat-embedded-temp");
        baseDir.mkdirs();
        return baseDir;
    }

    public static void debug(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }
}

