/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.tomcat;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.lang3.SystemUtils;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.kawanfw.sql.api.server.DatabaseConfigurationException;
import org.kawanfw.sql.api.util.SqlUtil;
import org.kawanfw.sql.servlet.connection.RollbackUtil;
import org.kawanfw.sql.servlet.injection.properties.ConfPropertiesUtil;
import org.kawanfw.sql.tomcat.AdvancedServletNamesGetterWrap;
import org.kawanfw.sql.tomcat.PoolPropertiesCreator;
import org.kawanfw.sql.tomcat.TomcatSqlModeStore;
import org.kawanfw.sql.util.SqlTag;
import org.kawanfw.sql.util.Tag;
import org.kawanfw.sql.version.EditionUtil;

public class TomcatStarterUtil {
    static String CR_LF = System.getProperty("line.separator");
    private static final String ERROR_MESSAGE = "Db Vendor is not supported in this version for Driver: ";

    protected TomcatStarterUtil() {
    }

    public static void createAndStoreDataSources(Properties properties) throws DatabaseConfigurationException, IOException, SQLException {
        if (properties == null) {
            throw new IllegalArgumentException("properties is null");
        }
        Set<String> databases = TomcatStarterUtil.getDatabaseNames(properties);
        for (String database : databases) {
            TomcatStarterUtil.createAndStoreDataSource(properties, database.trim());
        }
    }

    public static void addServlets(Properties properties, Context rootCtx) throws IOException, SQLException {
        if (properties == null) {
            throw new IllegalArgumentException("properties is null");
        }
        Set<String> servlets = AdvancedServletNamesGetterWrap.getServletsWrap(properties);
        if (servlets.isEmpty()) {
            return;
        }
        System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " Loading servlets:");
        for (String servlet : servlets) {
            String servletClassName = properties.getProperty(String.valueOf(servlet) + "." + "class");
            if (servletClassName == null || servletClassName.isEmpty()) {
                throw new IllegalArgumentException(String.valueOf(servlet) + ".class" + " property not found for servlet " + servlet + ". " + "Please correct and retry.");
            }
            servletClassName = servletClassName.trim();
            String servletUrl = properties.getProperty(String.valueOf(servlet) + "." + "url-pattern");
            if (servletUrl == null || servletUrl.isEmpty()) {
                throw new IllegalArgumentException(String.valueOf(servlet) + ".url-pattern" + " property not found for servlet " + servlet + ". " + "Please correct and retry.");
            }
            servletUrl = servletUrl.trim();
            Wrapper wrapper = Tomcat.addServlet((Context)rootCtx, (String)servlet, (String)servletClassName);
            rootCtx.addServletMappingDecoded(servletUrl, servlet);
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> Servlet " + servlet + " [url-pattern: " + servletUrl + "] successfully loaded.");
        }
    }

    public static Set<String> getServlets(Properties properties) {
        String servlets = properties.getProperty("servlets");
        if (servlets == null || servlets.isEmpty()) {
            return new HashSet<String>();
        }
        String[] servletArray = servlets.split(",");
        HashSet<String> servletSet = new HashSet<String>();
        int i = 0;
        while (i < servletArray.length) {
            servletSet.add(servletArray[i].trim());
            ++i;
        }
        return servletSet;
    }

    public static Set<String> getDatabaseNames(Properties properties) throws DatabaseConfigurationException {
        if (properties == null) {
            throw new IllegalArgumentException("properties is null");
        }
        String databases = properties.getProperty("databases");
        if (databases == null || databases.isEmpty()) {
            throw new DatabaseConfigurationException("the databases property is not set in properties file. Please correct and retry.");
        }
        String[] databaseArray = databases.split(",");
        HashSet<String> databaseSet = new HashSet<String>();
        int i = 0;
        while (i < databaseArray.length) {
            databaseSet.add(databaseArray[i].trim());
            ++i;
        }
        return databaseSet;
    }

    public static void createAndStoreDataSource(Properties properties, String database) throws DatabaseConfigurationException, IOException, SQLException {
        Objects.requireNonNull(properties, "properties cannot be null!");
        Objects.requireNonNull(database, "database cannot be null!");
        String driverClassName = properties.getProperty(String.valueOf(database) + "." + "driverClassName");
        String url = properties.getProperty(String.valueOf(database) + "." + "url");
        String username = properties.getProperty(String.valueOf(database) + "." + "username");
        String password = properties.getProperty(String.valueOf(database) + "." + "password");
        if (driverClassName == null || driverClassName.isEmpty()) {
            System.err.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " WARNING: driverClassName" + " property not found for database " + database + "! ");
            System.err.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "          Connection management must be defined in DatabaseConfigurator.getConnection(String database)");
            return;
        }
        TomcatStarterUtil.checkParameters(database, driverClassName, url, username, password);
        PoolProperties poolProperties = TomcatStarterUtil.createPoolProperties(properties, database);
        poolProperties = TomcatStarterUtil.addOurJdbcInterceptor(poolProperties);
        DataSource dataSource = new DataSource();
        dataSource.setPoolProperties((PoolConfiguration)poolProperties);
        Connection connection = null;
        try {
            try {
                System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " Testing DataSource.getConnection() for " + database + " database:");
                connection = dataSource.getConnection();
                if (connection == null) {
                    throw new DatabaseConfigurationException("Connection is null. Please verify all the values in properties file.");
                }
                if (ConfPropertiesUtil.isStatelessMode() && !connection.getAutoCommit()) {
                    throw new DatabaseConfigurationException("Server is in Stateless Mode: Connection pool must be in default auto commit. Please fix configuration.");
                }
                if (new SqlUtil(connection).isDB2() && !EditionUtil.isEnterpriseEdition()) {
                    throw new UnsupportedOperationException(String.valueOf(Tag.PRODUCT) + " " + "DB2 is not supported and " + "requires on server AceQL HTTP Enterprise Edition. See www.aceql.com.");
                }
                System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> Connection OK!");
            }
            catch (Exception e) {
                RollbackUtil.rollback(connection);
                throw new DatabaseConfigurationException(String.valueOf(e.getMessage()) + " " + e.getCause());
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        TomcatSqlModeStore.setDataSource(database, (javax.sql.DataSource)dataSource);
    }

    public static PoolProperties addOurJdbcInterceptor(PoolProperties poolProperties) {
        String existingJdbcInterceptors = poolProperties.getJdbcInterceptors();
        String jdbcInterceptors = "org.kawanfw.sql.tomcat.AceQLJdbcInterceptor";
        if (existingJdbcInterceptors != null && !existingJdbcInterceptors.isEmpty()) {
            jdbcInterceptors = String.valueOf(jdbcInterceptors) + ";" + existingJdbcInterceptors;
        }
        poolProperties.setJdbcInterceptors(jdbcInterceptors);
        return poolProperties;
    }

    private static PoolProperties createPoolProperties(Properties properties, String database) throws DatabaseConfigurationException {
        PoolPropertiesCreator poolPropertiesCreator = new PoolPropertiesCreator(properties, database);
        PoolProperties poolProperties = null;
        try {
            poolProperties = poolPropertiesCreator.create();
        }
        catch (Exception e) {
            throw new DatabaseConfigurationException(e.getMessage());
        }
        return poolProperties;
    }

    private static void checkParameters(String database, String driverClassName, String url, String username, String password) throws DatabaseConfigurationException, IOException, SQLException {
        if (url == null || url.isEmpty()) {
            throw new DatabaseConfigurationException("the url property is not set in properties file for driverClassName " + driverClassName + ". " + "Please correct and retry.");
        }
        if (username == null || username.isEmpty()) {
            throw new DatabaseConfigurationException("the username property is not set in properties file for driverClassName " + driverClassName + ". " + "Please correct and retry.");
        }
        if (password == null || password.isEmpty()) {
            throw new DatabaseConfigurationException("the password property is not set in properties file for driverClassName " + driverClassName + ". " + "Please correct and retry.");
        }
        System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " Setting Tomcat JDBC Pool attributes for " + database + " database:");
    }

    public static String trimSafe(String s) {
        String sNew = s;
        if (sNew != null) {
            sNew = sNew.trim();
        }
        return sNew;
    }

    public static boolean available(int port) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            return true;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static String getJavaInfo() {
        String vendor = SystemUtils.JAVA_VENDOR;
        return vendor == null || vendor.trim().isEmpty() || vendor.trim().equals("N/A") ? String.valueOf(SqlTag.SQL_PRODUCT_START) + " Java Info: " + CR_LF + SqlTag.SQL_PRODUCT_START + "  -> " + SystemUtils.JAVA_RUNTIME_NAME + " / " + SystemUtils.JAVA_VERSION : String.valueOf(SqlTag.SQL_PRODUCT_START) + " Java Info: " + CR_LF + SqlTag.SQL_PRODUCT_START + "  -> " + vendor + " / " + SystemUtils.JAVA_RUNTIME_NAME + " / " + SystemUtils.JAVA_VERSION;
    }
}

