/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.tomcat;

import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.Set;
import org.kawanfw.sql.tomcat.TomcatStarterUtil;
import org.kawanfw.sql.util.SqlTag;

public class TomcatStarterUtilInstancesTester {
    public static void testConfigurators(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties is null");
        }
        System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " Testing Declared Configurators:");
        Set<String> databases = TomcatStarterUtil.getDatabaseNames(properties);
        for (String database : databases) {
            String databaseConfiguratorClassName = properties.getProperty(String.valueOf(database) + "." + "databaseConfiguratorClassName");
            if (databaseConfiguratorClassName == null) continue;
            TomcatStarterUtilInstancesTester.loadInstance(databaseConfiguratorClassName);
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> " + database + " Database Configurator " + TomcatStarterUtil.CR_LF + SqlTag.SQL_PRODUCT_START + "     " + databaseConfiguratorClassName + " OK.");
        }
        String className = properties.getProperty("blobDownloadConfiguratorClassName");
        if (className != null) {
            TomcatStarterUtilInstancesTester.loadInstance(className);
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> Configurator " + className + " OK.");
        }
        if ((className = properties.getProperty("blobUploadConfiguratorClassName")) != null) {
            TomcatStarterUtilInstancesTester.loadInstance(className);
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> Configurator " + className + " OK.");
        }
        if ((className = properties.getProperty("sessionConfiguratorClassName")) != null) {
            TomcatStarterUtilInstancesTester.loadInstance(className);
            System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> Configurator " + className + " OK.");
        }
    }

    static void loadInstance(String configuratorClassName) {
        Class<?> c = null;
        try {
            c = Class.forName(configuratorClassName);
            Constructor<?> constructor = c.getConstructor(new Class[0]);
            Object obj = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception when loading Configurator " + configuratorClassName + ": " + e.toString() + ". " + "Please correct and retry.", e);
        }
    }
}

