/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.tomcat.properties.pool;

import org.kawanfw.sql.tomcat.properties.pool.PoolPropertiesInterceptor;

public class DefaultPoolPropertiesInterceptor
implements PoolPropertiesInterceptor {
    @Override
    public String interceptValue(String theMethod, String propertyValue) {
        if (theMethod == null || propertyValue == null) {
            return propertyValue;
        }
        String propertyValueUpdated = propertyValue;
        if (theMethod.equals("setMaxIdle")) {
            int maxAllowedValue = 125;
            propertyValueUpdated = this.getMaxAllowedValue(propertyValueUpdated, maxAllowedValue);
        } else if (theMethod.equals("setMaxActive")) {
            int maxAllowedValue = 125;
            propertyValueUpdated = this.getMaxAllowedValue(propertyValueUpdated, maxAllowedValue);
        }
        return propertyValueUpdated;
    }

    public String getMaxAllowedValue(String propertyValue, int maxAllowedValue) {
        try {
            int value = Integer.parseInt(propertyValue);
            if (value > maxAllowedValue) {
                return "" + maxAllowedValue;
            }
            return propertyValue;
        }
        catch (NumberFormatException e) {
            return propertyValue;
        }
    }
}

