/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.tomcat.properties.threadpool;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.kawanfw.sql.tomcat.properties.threadpool.ThreadPoolExecutorBuilder;
import org.kawanfw.sql.tomcat.properties.threadpool.ThreadPoolProperties;
import org.kawanfw.sql.util.SqlTag;

public class DefaultThreadPoolExecutorBuilder
implements ThreadPoolExecutorBuilder {
    @Override
    public ThreadPoolExecutor build() {
        int corePoolSize = 10;
        int maximumPoolSize = 125;
        TimeUnit unit = ThreadPoolProperties.DEFAULT_UNIT;
        long keepAliveTime = 60L;
        SynchronousQueue<Runnable> workQueue = new SynchronousQueue<Runnable>();
        boolean prestartAllCoreThreads = true;
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        if (prestartAllCoreThreads) {
            threadPoolExecutor.prestartAllCoreThreads();
        }
        System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + " Loading ThreadPoolExecutor:");
        System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  -> [corePoolSize: " + threadPoolExecutor.getCorePoolSize() + ", maximumPoolSize: " + threadPoolExecutor.getMaximumPoolSize() + ", unit: " + (Object)((Object)unit) + ", ");
        System.out.println(String.valueOf(SqlTag.SQL_PRODUCT_START) + "  ->  keepAliveTime: " + threadPoolExecutor.getKeepAliveTime(unit) + ", workQueue: " + threadPoolExecutor.getQueue().getClass().getSimpleName() + "(" + threadPoolExecutor.getQueue().remainingCapacity() + "), " + "prestartAllCoreThreads: " + prestartAllCoreThreads + "]");
        return threadPoolExecutor;
    }
}

