/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.tomcat.properties.threadpool;

import java.lang.reflect.Constructor;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.kawanfw.sql.api.server.DatabaseConfigurationException;

public class ThreadPoolProperties {
    public static final int DEFAULT_CORE_POOL_SIZE = 10;
    public static final int DEFAULT_MAXIMUM_POOL_SIZE = 125;
    public static final int DEFAULT_KEEP_ALIVE_TIME = 60;
    public static final String DEFAULT_BLOCKING_QUEUE_NAME = "java.util.concurrent.SynchronousQueue";
    public static final int DEFAULT_BLOCKING_QUEUE_CAPACITY = 0;
    public static final TimeUnit DEFAULT_UNIT = TimeUnit.SECONDS;
    public static final boolean PRESTART_ALL_CORE_THREADS = true;
    private String corePoolSizeStr;
    private String maximumPoolSizeStr;
    private String unitStr;
    private String keepAliveTimeStr;
    private String workQueueClassName;
    private String capacityStr;
    private String prestartAllCoreThreadsStr;
    private int corePoolSize = 10;
    private int maximumPoolSize = 125;
    private TimeUnit unit = DEFAULT_UNIT;
    private int keepAliveTime = 60;
    private int capacity = 0;
    private BlockingQueue<Runnable> workQueue;
    private boolean prestartAllCoreThreads;

    public ThreadPoolProperties(Properties properties) {
        Objects.requireNonNull(properties, "properties cannot be null!");
        this.corePoolSizeStr = properties.getProperty("corePoolSize");
        this.maximumPoolSizeStr = properties.getProperty("maximumPoolSize");
        this.unitStr = properties.getProperty("unit");
        this.keepAliveTimeStr = properties.getProperty("keepAliveTime");
        this.workQueueClassName = properties.getProperty("workQueueClassName");
        this.capacityStr = properties.getProperty("capacity");
        this.prestartAllCoreThreadsStr = properties.getProperty("prestartAllCoreThreads");
        this.checkAndFillParameters();
        this.createWorkingQueue();
    }

    private void createWorkingQueue() {
        String className = null;
        className = this.workQueueClassName != null ? this.workQueueClassName : DEFAULT_BLOCKING_QUEUE_NAME;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
            if (this.capacity > 0 && this.isConstructorWithCapacity(className)) {
                Constructor<?> constructor = clazz.getConstructor(Integer.TYPE);
                this.workQueue = (BlockingQueue)constructor.newInstance(this.capacity);
            } else {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                this.workQueue = (BlockingQueue)constructor.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            String CR_LF = System.getProperty("line.separator");
            throw new DatabaseConfigurationException("blockingQueueClassName instance for name " + className + " could not be created." + CR_LF + "Reason: " + e.toString() + ". " + "Please correct and retry.");
        }
    }

    public boolean isConstructorWithCapacity(String className) {
        return className.contains(ArrayBlockingQueue.class.getSimpleName()) || className.contains(PriorityBlockingQueue.class.getSimpleName()) || className.contains(LinkedBlockingDeque.class.getSimpleName());
    }

    private void checkAndFillParameters() {
        if (this.corePoolSizeStr != null) {
            this.throwExceptionValueIfNotNumeric("corePoolSize", this.corePoolSizeStr);
            this.corePoolSize = Integer.parseInt(this.corePoolSizeStr);
        }
        if (this.maximumPoolSizeStr != null) {
            this.throwExceptionValueIfNotNumeric("maximumPoolSize", this.maximumPoolSizeStr);
            this.maximumPoolSize = Integer.parseInt(this.maximumPoolSizeStr);
        }
        if (this.unitStr != null) {
            try {
                this.unit = TimeUnit.valueOf(this.unitStr);
            }
            catch (Exception e) {
                throw new DatabaseConfigurationException("unit value is invalid: " + this.unitStr + ". " + "Please correct and retry.");
            }
        }
        if (this.keepAliveTimeStr != null) {
            this.throwExceptionValueIfNotNumeric("keepAliveTime", this.keepAliveTimeStr);
            this.keepAliveTime = Integer.parseInt(this.keepAliveTimeStr);
        }
        if (this.capacityStr != null) {
            this.throwExceptionValueIfNotNumeric("capacity", this.capacityStr);
            this.capacity = Integer.parseInt(this.capacityStr);
        }
        if (this.maximumPoolSize < this.corePoolSize) {
            throw new DatabaseConfigurationException("maximumPoolSize (" + this.maximumPoolSize + ") is < corePoolSize (" + this.corePoolSize + "). maximumPoolSize Must be >= corePoolSize. " + "Please correct and retry.");
        }
        if (this.capacity < 0) {
            throw new DatabaseConfigurationException("capacity must be >= 0. Please correct and retry.");
        }
        this.prestartAllCoreThreads = this.prestartAllCoreThreadsStr == null || this.prestartAllCoreThreadsStr.isEmpty() ? true : Boolean.parseBoolean(this.prestartAllCoreThreadsStr);
    }

    private void throwExceptionValueIfNotNumeric(String name, String value) {
        if (!StringUtils.isNumeric((CharSequence)value)) {
            throw new DatabaseConfigurationException(String.valueOf(name) + " property is not numeric. " + "Please correct and retry.");
        }
    }

    public String getCapacityStr() {
        return this.capacityStr;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public int getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public BlockingQueue<Runnable> getWorkQueue() {
        return this.workQueue;
    }

    public boolean isPrestartAllCoreThreads() {
        return this.prestartAllCoreThreads;
    }
}

