/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.tomcat.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class LinkedProperties
extends Properties {
    private static final long serialVersionUID = 6588861237819163772L;
    private Set<String> orderedPropNames = new LinkedHashSet<String>();

    public LinkedProperties(Set<String> orderedPropNames) {
        this.orderedPropNames = orderedPropNames;
    }

    @Override
    public Set<String> stringPropertyNames() {
        LinkedHashSet<String> orderedPropNamesNew = new LinkedHashSet<String>();
        for (String propertyName : this.orderedPropNames) {
            if (!super.containsKey(propertyName)) continue;
            orderedPropNamesNew.add(propertyName);
        }
        return orderedPropNamesNew;
    }

    @Override
    public Enumeration<?> propertyNames() {
        LinkedHashSet<String> orderedPropNamesNew = new LinkedHashSet<String>();
        for (String propertyName : this.orderedPropNames) {
            if (!super.containsKey(propertyName)) continue;
            orderedPropNamesNew.add(propertyName);
        }
        return Collections.enumeration(orderedPropNamesNew);
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        Set<Object> set = this.keySet();
        return Collections.enumeration(set);
    }

    @Override
    public Set<Object> keySet() {
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        for (String obj : this.orderedPropNames) {
            set.add(obj);
        }
        return set;
    }

    public static Set<String> getLinkedPropertiesName(File fileProperties) throws IOException {
        LinkedHashSet<String> linkedPropertiesName = new LinkedHashSet<String>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(fileProperties));){
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("#") || line.startsWith("!") || !line.contains("=")) continue;
                line = StringUtils.substringBefore((String)line, (String)"=");
                line = line.trim();
                linkedPropertiesName.add(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return linkedPropertiesName;
    }
}

