/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.tomcat.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;

public class PortSemaphoreFile {
    private int port = -1;

    public PortSemaphoreFile(int port) {
        this.port = port;
    }

    public boolean exists() {
        return this.getSemaphoreFile().exists();
    }

    public boolean create() throws IOException {
        FileUtils.write((File)this.getSemaphoreFile(), (CharSequence)("" + this.port), (Charset)Charset.defaultCharset());
        return true;
    }

    public boolean delete() throws IOException {
        if (!this.getSemaphoreFile().exists()) {
            return true;
        }
        FileUtils.forceDelete((File)this.getSemaphoreFile());
        return true;
    }

    public File getSemaphoreFile() {
        String fileStr = System.getProperty("java.io.tmpdir");
        if (!fileStr.endsWith(File.separator)) {
            fileStr = String.valueOf(fileStr) + File.separator;
        }
        fileStr = String.valueOf(fileStr) + ".kawansoft";
        new File(fileStr).mkdir();
        if (!fileStr.endsWith(File.separator)) {
            fileStr = String.valueOf(fileStr) + File.separator;
        }
        fileStr = String.valueOf(fileStr) + "kawanfw-web-server-semaphore-port." + this.port;
        return new File(fileStr);
    }
}

