/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.tomcat.util.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Objects;

public class ConnectionCreator {
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private Exception exception;

    public ConnectionCreator(String driverClassName, String url, String username, String password) {
        this.driverClassName = Objects.requireNonNull(driverClassName, "driverClassName cannot be null!");
        this.url = Objects.requireNonNull(url, "url cannot be null!");
        this.username = Objects.requireNonNull(username, "username cannot be null!");
        this.password = Objects.requireNonNull(password, "password cannot be null!");
    }

    public boolean canCreateConnection() {
        try {
            Class.forName(this.driverClassName).newInstance();
            DriverManager.setLoginTimeout(10);
            Connection connection = DriverManager.getConnection(this.url, this.username, this.password);
            return connection != null;
        }
        catch (Exception e) {
            this.exception = e;
            return false;
        }
    }

    public Exception getException() {
        return this.exception;
    }
}

