/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.tomcat.util.jdbc;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.kawanfw.sql.api.server.DatabaseConfigurationException;
import org.kawanfw.sql.tomcat.TomcatStarterUtil;
import org.kawanfw.sql.tomcat.util.jdbc.JdbcInstanceInfo;

public class ConnectionCreatorUtil {
    public static List<JdbcInstanceInfo> createInstances(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties is null");
        }
        ArrayList<JdbcInstanceInfo> instances = new ArrayList<JdbcInstanceInfo>();
        Set<String> databases = TomcatStarterUtil.getDatabaseNames(properties);
        for (String database : databases) {
            String driverClassName = properties.getProperty(String.valueOf(database) + "." + "driverClassName");
            String url = properties.getProperty(String.valueOf(database) + "." + "url");
            String username = properties.getProperty(String.valueOf(database) + "." + "username");
            ConnectionCreatorUtil.checkParameters(database, driverClassName, url, username);
            JdbcInstanceInfo jdbcInstanceInfo = new JdbcInstanceInfo(driverClassName, url, username);
            instances.add(jdbcInstanceInfo);
        }
        return instances;
    }

    static void checkParameters(String database, String driverClassName, String url, String username) throws DatabaseConfigurationException {
        if (driverClassName == null || driverClassName.isEmpty()) {
            throw new DatabaseConfigurationException("the driverClassName property is not set in properties file for database " + database + ". " + "Please correct and retry.");
        }
        if (url == null || url.isEmpty()) {
            throw new DatabaseConfigurationException("the url property is not set in properties file for driverClassName " + driverClassName + ". " + "Please correct and retry.");
        }
        if (username == null || username.isEmpty()) {
            throw new DatabaseConfigurationException("the username property is not set in properties file for driverClassName " + driverClassName + ". " + "Please correct and retry.");
        }
    }
}

