/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.transport;

import org.apache.commons.lang3.StringUtils;
import org.kawanfw.sql.util.Base64;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.Tag;

public class TransportConverter {
    private static boolean DEBUG = FrameworkDebug.isSet(TransportConverter.class);
    public static String CR_LF = System.getProperty("line.separator");
    public static final String KAWANFW_BYTES = "**!kawanfw_bytes!**";
    public static final String KAWANFW_BYTES_STREAM_FILE = "**!kawanfw_stream_file!**";
    public static final String KAWANFW_STREAM_FAILURE = "**!kawanfw_stream_failure!**";
    public static final String KAWANFW_STREAM_NULL = "**!kawanfw_stream_null!**";

    protected TransportConverter() {
    }

    public static String toTransportFormat(byte[] x) {
        String encodedString = null;
        encodedString = x == null ? "**!kawanfw_bytes!**null" : KAWANFW_BYTES + Base64.byteArrayToBase64(x);
        return encodedString;
    }

    public static byte[] fromTransportFormatToBytes(String string) {
        String encodedString = StringUtils.substringAfter((String)string, (String)KAWANFW_BYTES);
        if (encodedString.equals("null")) {
            return null;
        }
        try {
            byte[] bytes = Base64.base64ToByteArray(encodedString);
            return bytes;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.valueOf(Tag.PRODUCT_PRODUCT_FAIL) + "String is not in BASE64 format: " + encodedString, e);
        }
    }

    private static void debug(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }
}

