/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.util;

import org.apache.commons.lang3.StringUtils;
import org.kawanfw.sql.util.FrameworkFileUtil;
import org.kawanfw.sql.util.Tag;

public class FileNameFromBlobBuilder {
    private static final String DELETE = "DELETE";
    private static final String INSERT = "INSERT";
    private static final String SELECT = "SELECT";
    private static final String UPDATE = "UPDATE";
    private static final String BLANK = " ";
    private String sqlOrder = null;
    private String columnName = null;
    private int parameterIndex = 0;
    private boolean isClob = false;

    public FileNameFromBlobBuilder(String sqlOrder, String columnName, boolean isClob) {
        if (sqlOrder == null) {
            throw new IllegalArgumentException(String.valueOf(Tag.PRODUCT_PRODUCT_FAIL) + "sqlOrder can not be null!");
        }
        if (columnName == null) {
            throw new IllegalArgumentException(String.valueOf(Tag.PRODUCT_PRODUCT_FAIL) + "columnName can not be null!");
        }
        this.sqlOrder = sqlOrder;
        this.columnName = columnName;
        this.isClob = isClob;
    }

    public FileNameFromBlobBuilder(String sqlOrder, int parameterIndex, boolean isClob) {
        if (sqlOrder == null) {
            throw new IllegalArgumentException(String.valueOf(Tag.PRODUCT_PRODUCT_FAIL) + "sqlOrder can not be null!");
        }
        if (parameterIndex < 1) {
            throw new IllegalArgumentException(String.valueOf(Tag.PRODUCT_PRODUCT_FAIL) + "Prepared statement parameterIndex must be >= 1");
        }
        this.sqlOrder = sqlOrder;
        this.parameterIndex = parameterIndex;
        this.isClob = isClob;
    }

    public String getFileName() {
        String fileName = null;
        String unique = FrameworkFileUtil.getUniqueId();
        this.sqlOrder = this.sqlOrder.trim();
        String statementType = StringUtils.substringBefore((String)this.sqlOrder, (String)BLANK);
        String tableName = this.getTableNameFromDmlStatement(statementType, this.sqlOrder);
        if (tableName == null) {
            tableName = "unknown";
        }
        if (statementType == null) {
            statementType = "unknown";
        }
        fileName = this.columnName != null ? String.valueOf(statementType.toLowerCase()) + "-" + tableName.toLowerCase() + "." + this.columnName + "-" + unique + ".blob" : String.valueOf(statementType.toLowerCase()) + "-" + tableName.toLowerCase() + "-index-" + this.parameterIndex + "-" + unique + ".blob";
        if (this.isClob) {
            fileName = String.valueOf(fileName) + ".clob.txt";
        }
        return fileName;
    }

    private String getTableNameFromDmlStatement(String statementType, String sql) throws IllegalArgumentException {
        String statementTypeUpper = statementType.toUpperCase();
        String sqlUpper = sql.toUpperCase();
        sqlUpper = StringUtils.substringAfter((String)sqlUpper, (String)statementTypeUpper);
        sqlUpper = sqlUpper.trim();
        String table = null;
        if (statementTypeUpper.equals(INSERT)) {
            sqlUpper = StringUtils.substringAfter((String)sqlUpper, (String)"INTO ");
            sqlUpper = sqlUpper.trim();
            table = StringUtils.substringBefore((String)sqlUpper, (String)BLANK);
        } else if (statementTypeUpper.equals(SELECT) || statementTypeUpper.equals(DELETE)) {
            sqlUpper = StringUtils.substringAfter((String)sqlUpper, (String)"FROM ");
            sqlUpper = sqlUpper.trim();
            sqlUpper = sqlUpper.replaceAll(",", BLANK);
            table = StringUtils.substringBefore((String)sqlUpper, (String)BLANK);
        } else if (statementTypeUpper.equals(UPDATE)) {
            table = StringUtils.substringBefore((String)sqlUpper, (String)BLANK);
        } else {
            return null;
        }
        if (table != null) {
            table = table.trim();
        }
        if (table.contains(".")) {
            table = StringUtils.substringAfterLast((String)table, (String)".");
        }
        table = table.replace("'", "");
        table = table.replace("\"", "");
        return table;
    }
}

