/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kawanfw.sql.util.FrameworkFileUtil;

public class FrameworkDebug {
    private static String ACEQL_DEBUG_FILE = "aceql-debug-server.ini";
    private static Set<String> CLASSES_TO_DEBUG = new HashSet<String>();

    protected FrameworkDebug() {
    }

    public static boolean isSet(Class<?> clazz) {
        FrameworkDebug.load();
        String className = clazz.getName();
        String rawClassName = StringUtils.substringAfterLast((String)className, (String)".");
        return CLASSES_TO_DEBUG.contains(className) || CLASSES_TO_DEBUG.contains(rawClassName);
    }

    private static void load() {
        if (!CLASSES_TO_DEBUG.isEmpty()) {
            return;
        }
        File kawansoftDir = new File(FrameworkFileUtil.getUserHomeDotKawansoftDir());
        kawansoftDir.mkdirs();
        String file = kawansoftDir + File.separator + ACEQL_DEBUG_FILE;
        if (!new File(file).exists()) {
            CLASSES_TO_DEBUG.add("empty");
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));){
                String line = null;
                while ((line = lineNumberReader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("//") || line.startsWith("#") || line.isEmpty()) continue;
                    CLASSES_TO_DEBUG.add(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Wrapped IOException. Impossible to load debug file: " + file, e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Wrapped IOException. Error reading debug file: " + file, e);
        }
    }
}

