/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.FrameworkSystemUtil;
import org.kawanfw.sql.util.Tag;

public class FrameworkFileUtil {
    private static boolean DEBUG = FrameworkDebug.isSet(FrameworkFileUtil.class);
    public static String CR_LF = System.getProperty("line.separator");

    protected FrameworkFileUtil() {
    }

    public static synchronized String getUniqueId() {
        UUID uuid = UUID.randomUUID();
        String uuidStr = uuid.toString();
        uuidStr = uuidStr.replace("-", "");
        return uuidStr;
    }

    public static String getUserHome() {
        String userHome = System.getProperty("user.home");
        if (!FrameworkSystemUtil.isAndroid()) {
            return userHome;
        }
        userHome = System.getProperty("java.io.tmpdir");
        if (!userHome.endsWith(File.separator)) {
            userHome = String.valueOf(userHome) + File.separator;
        }
        userHome = String.valueOf(userHome) + "kawansoft-user-home";
        File userHomeFile = new File(userHome);
        userHomeFile.mkdirs();
        return userHome;
    }

    public static String getUserHomeDotKawansoftDir() {
        String userHomeDotKwansoft = FrameworkFileUtil.getUserHome();
        if (!userHomeDotKwansoft.endsWith(File.separator)) {
            userHomeDotKwansoft = String.valueOf(userHomeDotKwansoft) + File.separator;
        }
        userHomeDotKwansoft = String.valueOf(userHomeDotKwansoft) + ".kawansoft";
        File tempDirFile = new File(userHomeDotKwansoft);
        tempDirFile.mkdirs();
        return userHomeDotKwansoft;
    }

    public static String getKawansoftTempDir() {
        String tempDir = String.valueOf(FrameworkFileUtil.getUserHomeDotKawansoftDir()) + File.separator + "tmp";
        File tempDirFile = new File(tempDir);
        tempDirFile.mkdirs();
        return tempDir;
    }

    public static String getFirstLineOfFile(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.valueOf(Tag.PRODUCT_PRODUCT_FAIL) + "receiveFile is null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(String.valueOf(Tag.PRODUCT_PRODUCT_FAIL) + "receiveFile does not exists: " + file);
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String firstLine = bufferedReader.readLine();
            return firstLine;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static boolean isPossibleLinuxFilename(String filename) {
        return filename.indexOf("\\") == -1 && filename.indexOf("/") == -1 && filename.indexOf(":") == -1 && filename.indexOf("*") == -1 && filename.indexOf("?") == -1 && filename.indexOf("\"") == -1 && filename.indexOf("<") == -1 && filename.indexOf(">") == -1 && filename.indexOf("|") == -1 && filename.indexOf("@") == -1 && filename.indexOf(" ") == -1;
    }

    public static boolean isUnlockedForRead(File file) {
        if (file.exists() && file.canRead()) {
            if (file.isDirectory()) {
                return true;
            }
            try {
                RandomAccessFile raf = new RandomAccessFile(file, "r");
                raf.close();
                FrameworkFileUtil.debug(new Date() + " " + file + " OK!");
                return true;
            }
            catch (Exception e) {
                FrameworkFileUtil.debug(new Date() + " " + file + " LOCKED! " + e.getMessage());
            }
        } else {
            FrameworkFileUtil.debug(new Date() + " " + file + " LOCKED! File exists(): " + file.exists() + " File canWrite: " + file.canWrite());
        }
        return false;
    }

    public static boolean isUnlockedForWrite(File file) {
        if (file.exists() && file.canWrite()) {
            if (file.isDirectory()) {
                return true;
            }
            try {
                RandomAccessFile raf = new RandomAccessFile(file, "rw");
                raf.close();
                FrameworkFileUtil.debug(new Date() + " " + file + " OK!");
                return true;
            }
            catch (Exception e) {
                FrameworkFileUtil.debug(new Date() + " " + file + " LOCKED! " + e.getMessage());
            }
        } else {
            FrameworkFileUtil.debug(new Date() + " " + file + " LOCKED! File exists(): " + file.exists() + " File canWrite: " + file.canWrite());
        }
        return false;
    }

    public static List<File> extractFilesOnly(List<File> fileList) {
        if (fileList == null) {
            throw new IllegalArgumentException("File list can't be null!");
        }
        if (fileList.isEmpty()) {
            return new Vector<File>();
        }
        Vector<File> files = new Vector<File>();
        int i = 0;
        while (i < fileList.size()) {
            if (!fileList.get(i).isDirectory()) {
                files.add(fileList.get(i));
            }
            ++i;
        }
        return files;
    }

    public static List<File> extractDirectoriesOnly(List<File> fileList) {
        Vector<File> directories = new Vector<File>();
        int i = 0;
        while (i < fileList.size()) {
            if (fileList.get(i).isDirectory()) {
                directories.add(fileList.get(i));
            }
            ++i;
        }
        return directories;
    }

    public static String getHtmlContent(File fileIn) throws IOException {
        if (fileIn == null) {
            throw new IllegalArgumentException("File name can't be null!");
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader br = new BufferedReader(new FileReader(fileIn));){
            String text = "";
            String line = null;
            while ((line = br.readLine()) != null) {
                text = String.valueOf(text) + line;
            }
            return text;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void debug(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }
}

