/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.util;

import org.apache.commons.lang3.StringUtils;
import org.kawanfw.sql.version.VersionWrapper;

public class JdbcUrlHeader {
    public static final String JDBC_URL_HEADER = "jdbc:" + VersionWrapper.getName().toLowerCase() + ":";

    protected JdbcUrlHeader() {
    }

    public static String getUrlHttpOnly(String url) {
        if (url == null) {
            throw new IllegalArgumentException("url is null!");
        }
        String urlHttpOnly = url;
        if (url.startsWith(JDBC_URL_HEADER)) {
            urlHttpOnly = StringUtils.substringAfter((String)url, (String)JDBC_URL_HEADER);
        }
        return urlHttpOnly;
    }

    public static String prefixUrlWithJdbcProductName(String url) {
        if (url == null) {
            throw new IllegalArgumentException("url is null!");
        }
        String urlNew = url;
        if (!urlNew.startsWith(JDBC_URL_HEADER)) {
            urlNew = String.valueOf(JDBC_URL_HEADER) + urlNew;
        }
        return urlNew;
    }
}

