/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.util.parser;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.kawanfw.sql.util.FrameworkDebug;
import org.kawanfw.sql.util.parser.keywords.SqlKeywords;

public class SqlStringTokenizer {
    public static boolean DEBUG = FrameworkDebug.isSet(SqlStringTokenizer.class);
    public static final String KAWAN_SINGLE_QUOTE = "__kawan_single_quote__";
    private static final String KAWAN_LT = "__kawan_lt__";
    private static final String KAWAN_GT = "__kawan_gt__";
    private static final String KAWAN_NE = "__kawan_ne__";
    private static final String KAWAN_NE_2 = "__kawan_ne2__";
    private static final String KAWAN_GTE = "__kawan_gte__";
    private static final String KAWAN_LTE = "__kawan_lte__";
    private static final String KAWAN_PLUS = "__kawan_plus__";
    private static final String KAWAN_MINUS = "__kawan_minus__";
    private static final String KAWAN_MULTIPLY = "__kawan_muliply__";
    private static final String KAWAN_DIVIDE = "__kawan_divide__";
    private static final String KAWAN_MODULO = "__kawan_modulo__";
    private static final String KAWAN_ADD_EQUALS = "__kawan_add_equals__";
    private static final String KAWAN_SUBTRACT_EQUALS = "__kawan_subtract_equals__";
    private static final String KAWAN_MULTIPLY_EQUALS = "__kawan_multiply_equals__";
    private static final String KAWAN_DIVIDE_EQUALS = "__kawan_divide_equals__";
    private static final String KAWAN_MODULO_EQUALS = "__kawan_modulo_equals__";
    private static final String KAWAN_BITWISE_AND_EQUALS = "__kawan_bitwise_and_equals__";
    private static final String KAWAN_BITWISE_EXCLUSIVE_EQUALS = "__kawan_bitwise_exclusive_equals__";
    private static final String KAWAN_BITWISE_OR_EQUALS = "__kawan_bitwise_or_equals__";
    private static final String KAWAN_HASHTAG = "__kawan_hashtag__";
    private static final String KAWAN_COMMENTS_MINUS = "__kawan_comments_minus__";
    private static final String KAWAN_COMMENTS_OPENING = "__kawan_comments_opening__";
    private static final String KAWAN_COMMENTS_CLOSING = "__kawan_comments_closing__";
    private static final String KAWAN_NULL_SAFE_EQUAL = "__kawan_null_safe_equal__";
    private static final String KAWAN_EXCLAMATION = "__KAWAN_EXCLAMATION__";
    private static final String KAWAN_AMPERSAND = "__KAWAN_AMPERSAND__";
    private static final String KAWAN_RIGHT_SHIFT = "__KAWAN_RIGHT_SHIFT__";
    private static final String KAWAN_LEFT_SHIFT = "__KAWAN_LEFT_SHIFT__";
    private static final String KAWAN_INVERT_BIT = "__KAWAN_INVERT_BIT__";
    private static final String KAWAN_BITWISE_OR = "__KAWAN_BITWISE_OR__";
    private static final String KAWAN_BITWISE_XOR = "__KAWAN_BITWISE_XOR__";

    public static List<String> getTokensSplitOnSpace(String str) {
        String strNew = str;
        strNew = SqlStringTokenizer.replaceOperatorsAddBlanksApache(strNew);
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(strNew, " ");
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken().trim();
            token = SqlKeywords.getKeywordSet().contains(token.toUpperCase()) ? token.toUpperCase() : token.toLowerCase();
            tokens.add(token);
        }
        return tokens;
    }

    public static String replaceOperatorsAddBlanksApache(String str) {
        String strNew = str;
        strNew = StringUtils.replace((String)strNew, (String)"(", (String)" ( ");
        strNew = StringUtils.replace((String)strNew, (String)")", (String)" ) ");
        strNew = StringUtils.replace((String)strNew, (String)",", (String)" , ");
        strNew = StringUtils.replace((String)strNew, (String)"!=", (String)KAWAN_NE);
        strNew = StringUtils.replace((String)strNew, (String)"<>", (String)KAWAN_NE_2);
        strNew = StringUtils.replace((String)strNew, (String)"<=>", (String)KAWAN_NULL_SAFE_EQUAL);
        strNew = StringUtils.replace((String)strNew, (String)">>", (String)KAWAN_RIGHT_SHIFT);
        strNew = StringUtils.replace((String)strNew, (String)"<<", (String)KAWAN_LEFT_SHIFT);
        strNew = StringUtils.replace((String)strNew, (String)">=", (String)KAWAN_GTE);
        strNew = StringUtils.replace((String)strNew, (String)"<=", (String)KAWAN_LTE);
        strNew = StringUtils.replace((String)strNew, (String)">", (String)KAWAN_GT);
        strNew = StringUtils.replace((String)strNew, (String)"<", (String)KAWAN_LT);
        strNew = StringUtils.replace((String)strNew, (String)"#", (String)KAWAN_HASHTAG);
        strNew = StringUtils.replace((String)strNew, (String)"--", (String)KAWAN_COMMENTS_MINUS);
        strNew = StringUtils.replace((String)strNew, (String)"/*", (String)KAWAN_COMMENTS_OPENING);
        strNew = StringUtils.replace((String)strNew, (String)"*/", (String)KAWAN_COMMENTS_CLOSING);
        strNew = StringUtils.replace((String)strNew, (String)"+=", (String)KAWAN_ADD_EQUALS);
        strNew = StringUtils.replace((String)strNew, (String)"-=", (String)KAWAN_SUBTRACT_EQUALS);
        strNew = StringUtils.replace((String)strNew, (String)"*=", (String)KAWAN_MULTIPLY_EQUALS);
        strNew = StringUtils.replace((String)strNew, (String)"/=", (String)KAWAN_DIVIDE_EQUALS);
        strNew = StringUtils.replace((String)strNew, (String)"%=", (String)KAWAN_MODULO_EQUALS);
        strNew = StringUtils.replace((String)strNew, (String)"&=", (String)KAWAN_BITWISE_AND_EQUALS);
        strNew = StringUtils.replace((String)strNew, (String)"^-=", (String)KAWAN_BITWISE_EXCLUSIVE_EQUALS);
        strNew = StringUtils.replace((String)strNew, (String)"|*=", (String)KAWAN_BITWISE_OR_EQUALS);
        strNew = StringUtils.replace((String)strNew, (String)"+", (String)KAWAN_PLUS);
        strNew = StringUtils.replace((String)strNew, (String)"-", (String)KAWAN_MINUS);
        strNew = StringUtils.replace((String)strNew, (String)"*", (String)KAWAN_MULTIPLY);
        strNew = StringUtils.replace((String)strNew, (String)"/", (String)KAWAN_DIVIDE);
        strNew = StringUtils.replace((String)strNew, (String)"%", (String)KAWAN_MODULO);
        strNew = StringUtils.replace((String)strNew, (String)"!", (String)KAWAN_EXCLAMATION);
        strNew = StringUtils.replace((String)strNew, (String)"&", (String)KAWAN_AMPERSAND);
        strNew = StringUtils.replace((String)strNew, (String)"~", (String)KAWAN_INVERT_BIT);
        strNew = StringUtils.replace((String)strNew, (String)"|", (String)KAWAN_BITWISE_OR);
        strNew = StringUtils.replace((String)strNew, (String)"^", (String)KAWAN_BITWISE_XOR);
        strNew = StringUtils.replace((String)strNew, (String)"=", (String)" = ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_ADD_EQUALS, (String)" += ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_SUBTRACT_EQUALS, (String)" -= ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_MULTIPLY_EQUALS, (String)" *= ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_DIVIDE_EQUALS, (String)" /= ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_MODULO_EQUALS, (String)" %= ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_BITWISE_AND_EQUALS, (String)" &= ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_BITWISE_EXCLUSIVE_EQUALS, (String)" ^-= ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_BITWISE_OR_EQUALS, (String)" |*= ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_RIGHT_SHIFT, (String)" >> ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_LEFT_SHIFT, (String)" << ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_PLUS, (String)" + ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_MINUS, (String)" - ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_MULTIPLY, (String)" * ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_DIVIDE, (String)" / ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_MODULO, (String)" % ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_GTE, (String)" >= ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_LTE, (String)" <= ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_GT, (String)" > ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_LT, (String)" < ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_HASHTAG, (String)" # ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_COMMENTS_MINUS, (String)" -- ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_COMMENTS_OPENING, (String)" /* ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_COMMENTS_CLOSING, (String)" */ ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_EXCLAMATION, (String)" ! ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_AMPERSAND, (String)" & ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_INVERT_BIT, (String)" ~ ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_BITWISE_OR, (String)" | ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_BITWISE_XOR, (String)" ^ ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_NE, (String)" != ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_NE_2, (String)" <> ");
        strNew = StringUtils.replace((String)strNew, (String)KAWAN_NULL_SAFE_EQUAL, (String)" <=> ");
        return strNew;
    }

    public static String tokensTrimAndConcatenate(List<String> tokens) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String token : tokens) {
            if (token.isEmpty()) continue;
            token = token.trim();
            SqlStringTokenizer.debug("display 4:" + token);
            stringBuffer.append(token);
            stringBuffer.append(" ");
        }
        String str = stringBuffer.toString();
        return str.trim();
    }

    public static List<String> getTokensSplitOnSinglesQuotes(String sql) {
        Objects.requireNonNull(sql, "sql cannot be null!");
        String sqlToSplit = sql.replace("''", KAWAN_SINGLE_QUOTE);
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(sqlToSplit, "'", false);
        while (stringTokenizer.hasMoreElements()) {
            tokens.add(stringTokenizer.nextToken());
        }
        return tokens;
    }

    public static void debug(String s) {
        if (DEBUG) {
            System.out.println(new Date() + " " + s);
        }
    }
}

