/*
 * Decompiled with CFR 0.152.
 */
package org.kawanfw.sql.util.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;

public class Invoker {
    protected Invoker() {
    }

    public static Object getMethodResult(Object concreteInstance, String methodName, Object ... param) throws SecurityException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> c = concreteInstance.getClass();
        Object obj = Invoker.getMethodResult(concreteInstance, methodName, c, param);
        return obj;
    }

    private static Object getMethodResult(Object concreteInstance, String methodName, Class<?> c, Object ... param) throws SecurityException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method[] allMethods = c.getDeclaredMethods();
        boolean methodExists = false;
        Method[] methodArray = allMethods;
        int n = allMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(methodName)) {
                methodExists = true;
                break;
            }
            ++n2;
        }
        Class[] argTypes = new Class[param.length];
        int i = 0;
        while (i < param.length) {
            argTypes[i] = param[i].getClass();
            ++i;
        }
        if (methodExists) {
            Method main = c.getDeclaredMethod(methodName, argTypes);
            Object result = main.invoke(concreteInstance, param);
            return result;
        }
        Class<?> cSuper = c.getSuperclass();
        if (cSuper == null) {
            return null;
        }
        return Invoker.getMethodResult(concreteInstance, methodName, cSuper, param);
    }

    public static boolean existsMethod(String className, String methodName) throws SQLException {
        Class<?> c = null;
        try {
            c = Class.forName(className);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        Method[] allMethods = c.getDeclaredMethods();
        boolean methodExists = false;
        Method[] methodArray = allMethods;
        int n = allMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(methodName)) {
                methodExists = true;
                break;
            }
            ++n2;
        }
        return methodExists;
    }
}

