
package actionjava.anim;

import java.util.Iterator;

import actionjava.anim.core.Tween;
import actionjava.anim.core.TweenContainer;
import actionjava.anim.core.TweenProp;
import actionjava.utils.Ticker;
import actionjava.utils.Ticker.ITickObserver;

class AnimEngine implements ITickObserver
{
	TweenContainer rootContainer;

	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & Initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//

	AnimEngine()
	{
		super();
		initialize();
	}

	private void initialize()
	{
		rootContainer = new TweenContainer();
		Ticker.registerObserver(this);
	}

	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Functionality
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//

	@Override
	public void update(double time)
	{
		render(rootContainer, (time / 1000));
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Render AnimContainer
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	private void render(TweenContainer container, double time)
	{
		container.setTime(time);
		Iterator<Tween> iterator = container.getIterator();
		while (iterator.hasNext()) {
			Tween tw = iterator.next();
			if(tw.isActive()) {
				render(tw, time);
			}
		}
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Render Tween
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	private void render(Tween tw, double time)
	{
		tw.setElapsedTime(time - tw.getStartTime());
		double ratio = tw.beforeRender();

		TweenProp tp;
		Iterator<TweenProp> tpIterator = tw.getIterator();
		while (tpIterator.hasNext()) {
			tp = tpIterator.next();
			tp.set((tp.getChange() * ratio) + tp.getStart());
		}

		tw.afterRender();
	}
}
