
package actionjava.anim;

public interface ITween
{
	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public Object getTarget();

	public double getDuration();

	public boolean isActive();

	public boolean isPaused();

	public boolean isReversed();

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Tween Controls
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Play
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public void play();

	public void play(double from);

	public void play(double from, boolean suppressEvents);

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Pause
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public void pause();

	public void pause(double atTime);

	public void pause(double atTime, boolean suppressEvents);

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Resume
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public void resume();

	public void resume(double from);

	public void resume(double from, boolean suppressEvents);

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Seek
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public void seek(double time);

	public void seek(double time, boolean suppressEvents);

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Restart
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public void restart(boolean includeDelay);

	public void restart(boolean includeDelay, boolean suppressEvents);

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Reverse
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	public void reverse(double from);

	public void reverse(double from, boolean suppressEvents);
}
