
package actionjava.anim.config;

import java.util.HashMap;
import java.util.Map;
import actionjava.anim.events.TweenEvent;
import actionjava.anim.events.TweenEventHandler;
import actionjava.anim.events.TweenEventParams;
import actionjava.anim.events.TweenEvent.TweenEventType;

abstract class Events extends TweenEventHandler
{
	private Map<TweenEventType, TweenEventParams> params = new HashMap<TweenEventType, TweenEventParams>();
	private Map<TweenEventType, TweenEventHandler> listeners = new HashMap<TweenEventType, TweenEventHandler>();

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public Events()
	{
		super(null);
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Add & Remove EventListeners / EventParams
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public void addListener(String name, TweenEventHandler listener)
	{
		addListener(name, listener, null);
	}

	public void addListener(String name, TweenEventHandler listener, TweenEventParams params)
	{
		TweenEventType type = getEventType(name);
		if(type != null) {
			addListener(type, listener, params);
		}
	}

	public void addListener(TweenEventType type, TweenEventHandler listener)
	{
		addListener(type, listener, null);
	}

	public void addListener(TweenEventType type, TweenEventHandler listener, TweenEventParams params)
	{
		this.listeners.put(type, listener);
		this.params.put(type, params);
	}

	public void removeListenerByName(String name)
	{
		TweenEventType type = getEventType(name);
		if(type != null) {
			removeListenerByType(type);
		}
	}

	public void removeListenerByType(TweenEventType type)
	{
		this.listeners.remove(type);
		this.params.remove(type);
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters, Setters & Remove EventListeners / EventParams
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public Map<TweenEventType, TweenEventParams> getEventParams()
	{
		return params;
	}

	public Map<TweenEventType, TweenEventHandler> getEventListeners()
	{
		return listeners;
	}

	public TweenEventHandler getListenerByName(String name)
	{
		TweenEventType type = getEventType(name);
		if(type != null) { return getListenerByType(type); }
		return null;
	}

	public TweenEventHandler getListenerByType(TweenEventType type)
	{
		return this.listeners.get(type);
	}

	public TweenEventParams getParamsByName(String name)
	{
		TweenEventType type = getEventType(name);
		if(type != null) { return getParamsByType(type); }
		return null;
	}

	public TweenEventParams getParamsByType(TweenEventType type)
	{
		return params.get(type);
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Private Functionality
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	private TweenEventType getEventType(String name)
	{
		TweenEventType[] types = TweenEventType.values();
		for(int i = 0;i < types.length;i++) {
			if(types[i].getType().equals(name)) { return types[i]; }
		}
		return null;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Event Handlers (Override to use)
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	@Override
	protected void tweenStart(TweenEvent event, TweenEventParams params)
	{
	}

	@Override
	protected void tweenUpdate(TweenEvent event, TweenEventParams params)
	{
	}

	@Override
	protected void tweenComplete(TweenEvent event, TweenEventParams params)
	{
	}

	@Override
	protected void tweenReverseComplete(TweenEvent event, TweenEventParams params)
	{
	}
}
