
package actionjava.anim.core.props;

import actionjava.display.DisplayObject;

class Alpha extends PropBridge implements IPropBridge
{
	private DisplayObject target;

	public Alpha(Object target)
	{
		super(target);
	}

	@Override
	public double get()
	{
		return target.getAlpha();
	}

	@Override
	public void set(double value)
	{
		target.setAlpha(value);
	}

	@Override
	boolean checkCompatibility(Object target)
	{
		if(target instanceof DisplayObject) {
			this.target = (DisplayObject) target;
			return true;
		}
		return false;
	}

	@Override
	public Object getTarget()
	{
		return target;
	}
}
