
package actionjava.anim.core.props;

public abstract class PropBridge implements IPropBridge
{
	public PropBridge(Object target)
	{
		if(!checkCompatibility(target)) { throw new UnsupportedOperationException("Target doesn't support this adapter"); }
	}

	@Override
	public abstract double get();

	@Override
	public abstract void set(double value);

	@Override
	public abstract Object getTarget();

	abstract boolean checkCompatibility(Object target);
}
