
package actionjava.anim.core.props;

import actionjava.anim.config.PropType;

public final class PropBridgeFactory
{
	private enum PropBridge
	{
		X
		{
			@Override
			public String getName()
			{
				return getType().getName();
			}

			@Override
			public PropType getType()
			{
				return PropType.X;
			}

			@Override
			public IPropBridge getBridge(Object target)
			{
				return new X(target);
			}
		},
		Y
		{
			@Override
			public String getName()
			{
				return getType().getName();
			}

			@Override
			public PropType getType()
			{
				return PropType.Y;
			}

			@Override
			public IPropBridge getBridge(Object target)
			{
				return new Y(target);
			}
		},
		WIDTH
		{
			@Override
			public String getName()
			{
				return getType().getName();
			}

			@Override
			public PropType getType()
			{
				return PropType.WIDTH;
			}

			@Override
			public IPropBridge getBridge(Object target)
			{
				return new Width(target);
			}
		},
		HEIGHT
		{
			@Override
			public String getName()
			{
				return getType().getName();
			}

			@Override
			public PropType getType()
			{
				return PropType.HEIGHT;
			}

			@Override
			public IPropBridge getBridge(Object target)
			{
				return new Height(target);
			}
		},
		SCALE_X
		{
			@Override
			public String getName()
			{
				return getType().getName();
			}

			@Override
			public PropType getType()
			{
				return PropType.SCALE_X;
			}

			@Override
			public IPropBridge getBridge(Object target)
			{
				return new ScaleX(target);
			}
		},
		SCALE_Y
		{
			@Override
			public String getName()
			{
				return getType().getName();
			}

			@Override
			public PropType getType()
			{
				return PropType.SCALE_Y;
			}

			@Override
			public IPropBridge getBridge(Object target)
			{
				return new ScaleY(target);
			}
		},
		SKEW_X
		{
			@Override
			public String getName()
			{
				return getType().getName();
			}

			@Override
			public PropType getType()
			{
				return PropType.SKEW_X;
			}

			@Override
			public IPropBridge getBridge(Object target)
			{
				return new SkewX(target);
			}
		},
		SKEW_Y
		{
			@Override
			public String getName()
			{
				return getType().getName();
			}

			@Override
			public PropType getType()
			{
				return PropType.SKEW_Y;
			}

			@Override
			public IPropBridge getBridge(Object target)
			{
				return new SkewY(target);
			}
		},
		ROTATION
		{
			@Override
			public String getName()
			{
				return getType().getName();
			}

			@Override
			public PropType getType()
			{
				return PropType.ROTATION;
			}

			@Override
			public IPropBridge getBridge(Object target)
			{
				return new Rotation(target);
			}
		},
		ALPHA
		{
			@Override
			public String getName()
			{
				return getType().getName();
			}

			@Override
			public PropType getType()
			{
				return PropType.ALPHA;
			}

			@Override
			public IPropBridge getBridge(Object target)
			{
				return new Alpha(target);
			}
		};

		public abstract String getName();

		public abstract PropType getType();

		public abstract IPropBridge getBridge(Object target);
	}

	public static IPropBridge createBridgeByType(Object target, PropType propType)
	{
		PropBridge[] bridges = PropBridge.values();
		for(int i = 0;i < bridges.length;i++) {
			if(bridges[i].getType() == propType) { return bridges[i].getBridge(target); }
		}
		return null;
	}

	public static IPropBridge createBridgeByName(Object target, String propName)
	{
		PropBridge[] bridges = PropBridge.values();
		for(int i = 0;i < bridges.length;i++) {
			if(bridges[i].getName().equals(propName)) { return bridges[i].getBridge(target); }
		}
		return null;
	}
}
