
package actionjava.anim.core.props;

import actionjava.display.DisplayObject;

class Rotation extends PropBridge implements IPropBridge
{
	private DisplayObject target;

	public Rotation(Object target)
	{
		super(target);
	}

	@Override
	public double get()
	{
		return target.getRotation();
	}

	@Override
	public void set(double value)
	{
		target.setRotation(value);
	}

	@Override
	boolean checkCompatibility(Object target)
	{
		if(target instanceof DisplayObject) {
			this.target = (DisplayObject) target;
			return true;
		}
		return false;
	}

	@Override
	public Object getTarget()
	{
		return target;
	}
}
