
package actionjava.anim.core.props;

import actionjava.display.DisplayObject;

class ScaleX extends PropBridge implements IPropBridge
{
	private DisplayObject target;

	public ScaleX(Object target)
	{
		super(target);
	}

	@Override
	public double get()
	{
		return target.getScaleX();
	}

	@Override
	public void set(double value)
	{
		target.setScaleX(value);
	}

	@Override
	boolean checkCompatibility(Object target)
	{
		if(target instanceof DisplayObject) {
			this.target = (DisplayObject) target;
			return true;
		}
		return false;
	}

	@Override
	public Object getTarget()
	{
		return target;
	}
}
