
package actionjava.anim.core.props;

import actionjava.display.DisplayObject;

class ScaleY extends PropBridge implements IPropBridge
{
	private DisplayObject target;

	public ScaleY(Object target)
	{
		super(target);
	}

	@Override
	public double get()
	{
		return target.getScaleY();
	}

	@Override
	public void set(double value)
	{
		target.setScaleY(value);
	}

	@Override
	boolean checkCompatibility(Object target)
	{
		if(target instanceof DisplayObject) {
			this.target = (DisplayObject) target;
			return true;
		}
		return false;
	}

	@Override
	public Object getTarget()
	{
		return target;
	}
}
