
package actionjava.anim.core.props;

import actionjava.display.DisplayObject;

class SkewX extends PropBridge implements IPropBridge
{
	private DisplayObject target;

	public SkewX(Object target)
	{
		super(target);
	}

	@Override
	public double get()
	{
		return target.getSkewX();
	}

	@Override
	public void set(double value)
	{
		target.setSkewX(value);
	}

	@Override
	boolean checkCompatibility(Object target)
	{
		if(target instanceof DisplayObject) {
			this.target = (DisplayObject) target;
			return true;
		}
		return false;
	}

	@Override
	public Object getTarget()
	{
		return target;
	}
}
