
package actionjava.anim.ease;

public class EasePoint
{
	private double time;
	private double gap;
	private double value;
	private double change;
	private EasePoint next;
	private EasePoint prev;

	public EasePoint(double time, double value)
	{
		super();
		initialize(time, value, null);
	}

	public EasePoint(double time, double value, EasePoint next)
	{
		super();
		initialize(time, value, next);
	}

	private void initialize(double time, double value, EasePoint next)
	{
		this.time = time;
		this.value = value;
		if(next != null) {
			this.next = next;
			next.prev = this;
			this.change = next.value - value;
			this.gap = next.time - time;
		}
	}

	public double getTime()
	{
		return time;
	}

	public void setTime(double time)
	{
		this.time = time;
	}

	public double getGap()
	{
		return gap;
	} 

	public void setGap(double gap)
	{
		this.gap = gap;
	}

	public double getValue()
	{
		return value;
	}

	public void setValue(double value)
	{
		this.value = value;
	}

	public double getChange()
	{
		return change;
	}

	public void setChange(double change)
	{
		this.change = change;
	}

	public EasePoint getNext()
	{
		return next;
	}

	public void setNext(EasePoint next)
	{
		this.next = next;
	}

	public EasePoint getPrev()
	{
		return prev;
	}

	public void setPrev(EasePoint prev)
	{
		this.prev = prev;
	}
}
