
package actionjava.anim.ease;

public class ElasticInOut extends Ease
{
	private static final double PI2 = Math.PI * 2;
	public static ElasticInOut ease = new ElasticInOut();

	public ElasticInOut()
	{
		super();
		initialize(1, 0.45);
	}

	public ElasticInOut(double amplitude)
	{
		super();
		initialize(amplitude, 0.45);
	}

	public ElasticInOut(double amplitude, double period)
	{
		super();
		initialize(amplitude, period);
	}

	private void initialize(double amplitude, double period)
	{
		p1 = amplitude;
		p2 = period;
		p3 = p2 / PI2 * Math.asin(1 / p1);
	}

	@Override
	public double getRatio(double p)
	{
		return ((p *= 2) < 1) ? -.5 * (p1 * Math.pow(2, 10 * (p -= 1)) * Math.sin((p - p3) * PI2 / p2)) : p1 * Math.pow(2, -10 * (p -= 1)) * Math.sin((p - p3) * PI2 / p2) * .5 + 1;
	}
}
