
package actionjava.anim.ease;

public class SlowMo extends Ease
{
	public static SlowMo ease = new SlowMo();
	private double pow;

	public SlowMo()
	{
		super();
		initialize(0.7, 0.7, false);
	}

	public SlowMo(double linearRatio)
	{
		super();
		initialize(linearRatio, 0.7, false);
	}

	public SlowMo(double linearRatio, double power)
	{
		super();
		initialize(linearRatio, power, false);
	}

	public SlowMo(double linearRatio, double power, boolean yoyoMode)
	{
		super();
		initialize(linearRatio, power, yoyoMode);
	}

	private void initialize(double linearRatio, double power, boolean yoyoMode)
	{
		if(linearRatio > 1) {
			linearRatio = 1;
		}
		pow = (linearRatio != 1) ? power : 0;
		p1 = (1 - linearRatio) / 2;
		p2 = linearRatio;
		p3 = p1 + p2;
		calcEnd = yoyoMode;
	}

	@Override
	public double getRatio(double p)
	{
		double r = p + (0.5 - p) * pow;
		if(p < p1) {
			return calcEnd ? 1 - ((p = 1 - (p / p1)) * p) : r - ((p = 1 - (p / p1)) * p * p * p * r);
		} else if(p > p3) { return calcEnd ? 1 - (p = (p - p3) / p1) * p : r + ((p - r) * (p = (p - p3) / p1) * p * p * p); }
		return calcEnd ? 1 : r;
	}
}
