
package actionjava.anim.ease;

public class SteppedEase extends Ease
{
	private int steps;

	public SteppedEase(int steps)
	{
		p1 = 1 / steps;
		this.steps = steps + 1;
	}

	public static SteppedEase create(int steps)
	{
		return new SteppedEase(steps);
	}

	@Override
	public double getRatio(double p)
	{
		if(p < 0) {
			p = 0;
		} else if(p >= 1) {
			p = 0.999999999;
		}
		return ((steps * (int) p) >> 0) * p1;
	}

	public int getSteps()
	{
		return steps - 1;
	}
}
